% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikertEZ.R
\name{summary_table_all}
\alias{summary_table_all}
\title{Create a tidy summary table of all items}
\usage{
summary_table_all(data, max_scale = 5, scale_labels = NULL, decimals = 2)
}
\arguments{
\item{data}{A data.frame of ordinal items.}

\item{max_scale}{Max value on the Likert scale (default: 5).}

\item{scale_labels}{Optional vector of labels for each scale point.}

\item{decimals}{Number of decimal places for percentages (default: 2).}
}
\value{
A data.frame with summary statistics for all items.
}
\description{
This function generates a tidy summary table for all ordinal items in a data.frame. The table includes statistics such as mean, median, standard deviation, counts, and percentages.
}
\examples{
dat <- data.frame(Q1 = c(1, 2, 3, 4, 5), Q2 = c(2, 2, 3, 4, NA))
summary_table_all(dat)
}
