\name{KMPlot}
\alias{KMPlot}
\title{
KM plot for SurvCART object
}
\description{
Generates KM plot for sub-groups (i.e., terminal nodes) associated with survival tree generated by SurvCART()
}
\usage{
KMPlot(x, type = 1, overlay=TRUE, conf.type="log-log", mfrow=NULL, ...)
}
\arguments{
  \item{x}{a fitted object of class \code{"SurvCART"}, containing a survival tree.}
  \item{type}{1 for KM plot of survival probabilities, 2 for KM plot of censoring probabilities}
  \item{overlay}{Logical inputs (\code{TRUE} or \code{FALSE}) whether the KM plots for different subgroups will be overlaid in the same plot or separate plots to be generated}
  \item{conf.type}{One of \code{none}, \code{plain}, \code{log}, or \code{log-log}. The first option causes confidence intervals not to be generated. This  input is ignored when \code{overlay=TRUE}.}
  \item{mfrow}{Desired frame for fitting multiple plots. Default option is to include plots for all subgroups in the same frame. This  input is ignored when \code{overlay=TRUE}.}
  \item{...}{arguments to be passed to or from other methods.}
}
\author{ Madan Gopal Kundu \email{madan_g.kundu@yahoo.com}}

\references{
Kundu, M. G., and Ghosh, S. (2021). Survival trees based on heterogeneity in time-to-event and censoring distributions using parameter instability test. Statistical Analysis and Data Mining: The ASA Data Science Journal, 14(5), 466-483.
}
\seealso{
\code{\link{text}}, \code{\link{plot}}, \code{\link{SurvCART}}, \code{\link{StabCat.surv}}, \code{\link{StabCont.surv}}
}

\examples{
\donttest{
#--- Get the data
data(GBSG2)

#numeric coding of character variables
GBSG2$horTh1<- as.numeric(GBSG2$horTh)
GBSG2$tgrade1<- as.numeric(GBSG2$tgrade)
GBSG2$menostat1<- as.numeric(GBSG2$menostat)

#Add subject id
GBSG2$subjid<- 1:nrow(GBSG2)

#--- Run SurvCART() with time-to-event distribution: exponential, censoring distribution: None  
out<- SurvCART(data=GBSG2, patid="subjid", censorvar="cens", timevar="time", 
        gvars=c('horTh1', 'age', 'menostat1', 'tsize', 'tgrade1', 'pnodes', 'progrec', 'estrec'),  
        tgvars=c(0,1,0,1,0,1, 1,1),          
        event.ind=1,  alpha=0.05, minsplit=80, minbucket=40, print=TRUE)

#--- Plot tree
par(xpd = TRUE)
plot(out, compress = TRUE)
text(out, use.n = TRUE)

#Plot KM plot of survival probabilities for sub-groups identified by tree
KMPlot(out, xscale=365.25, type=1)
KMPlot(out, xscale=365.25, type=1, overlay=FALSE, mfrow=c(2,2), xlab="Year", ylab="Survival prob.")

#Plot KM plot of censoring probabilities for sub-groups identified by tree
KMPlot(out, xscale=365.25, type=2)
KMPlot(out, xscale=365.25, type=2, overlay=FALSE, mfrow=c(2,2), xlab="Year", ylab="Censoring prob.")
}
}
