% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeanspp.R
\name{kmeanspp}
\alias{kmeanspp}
\title{A new version of kmeans that generates stable cluster result}
\usage{
kmeanspp(X, k)
}
\arguments{
\item{X}{a data matrix with each row as a sample and each column as a feature}

\item{k}{the cluster number}
}
\value{
res, the cluster result generated by this function
}
\description{
A new version of kmeans that generates stable cluster result
}
\examples{
library(InterSIM)
sim.data <- InterSIM(n.sample=500, cluster.sample.prop = c(0.20,0.30,0.27,0.23),
delta.methyl=5, delta.expr=5, delta.protein=5,p.DMP=0.2, p.DEG=NULL,
p.DEP=NULL,sigma.methyl=NULL, sigma.expr=NULL, sigma.protein=NULL,cor.methyl.expr=NULL,
cor.expr.protein=NULL,do.plot=FALSE, sample.cluster=TRUE, feature.cluster=TRUE)
sim.methyl <- sim.data$dat.methyl
sim.expr <- sim.data$dat.expr
sim.protein <- sim.data$dat.protein
temp_data <- list(sim.methyl, sim.expr, sim.protein)
init_list <- initialize_WL(temp_data,k=4)
lambda <- 0.01
update_E_list <- update_E(temp_data,init_list,lambda)
cluster_res <- kmeanspp(update_E_list[[4]],4)
}
