% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ObservationCounts.R
\name{plot_binned_counts}
\alias{plot_binned_counts}
\title{Plot counts of observations across bins of a numeric variable, optionally stratified}
\usage{
plot_binned_counts(
  data,
  x,
  bin_by,
  stratify_by = NULL,
  for_each = NULL,
  n_bins = 8,
  bin_width = NULL,
  title = "Observation counts",
  subtitle = NULL,
  legend_title = NULL,
  x_lab = NULL,
  y_lab = NULL,
  viridis_color_option = "D"
)
}
\arguments{
\item{data}{Data frame containing all input variables.}

\item{x}{Variable in \code{data} whose values define the x-axis for counts.}

\item{bin_by}{Numeric variable in \code{data} for which to bin observations.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, counts are computed for each combination of \code{x}, bin of \code{bin_by} and
\code{stratify_by}, and separate panels are made for each level of \code{stratify_by}.}

\item{for_each}{(Optional) Additional stratification variable. If supplied,
separate plot windows are created per level of \code{for_each}.}

\item{n_bins}{(Optional) Number of bins to create across \code{bin_by}; defaults to 8.}

\item{bin_width}{(Optional) Width of the bins created across \code{bin_by}; defaults to NULL.
Overrides \code{n_bins} if both are supplied.}

\item{title}{(Optional) Plot title; defaults to \code{"Observation counts"}.}

\item{subtitle}{(Optional) Plot subtitle; defaults to \code{NULL} if for \code{for_each} is \code{NULL},
defaults to \code{<name of for_each>: <level of for_each>} for each plot window if \code{for_each} is supplied.}

\item{legend_title}{(Optional) Legend title; defaults to name of \code{bin_by} + "bin".}

\item{x_lab}{(Optional) Label for the x-axis; defaults to the name of \code{x}.}

\item{y_lab}{(Optional) Label for the y-axis; defaults to the name of \code{y}.}

\item{viridis_color_option}{(Optional) Option for color gradient; defaults to "D".
Options are "A", "B", "C", "D", E", "F", "G", "H".
See \pkg{viridis} for information, or experiment yourself.}
}
\value{
If \code{for_each} is not supplied, a \link[ggplot2]{ggplot} object showing counts
per \code{x} and bin groups, optionally faceted by \code{stratify_by}. If \code{for_each}
is supplied, a named list of such plots.
}
\description{
Bins a specified numeric variable into intervals, counts observations per value of a specified variable and bin groups,
and plots lines for each bin group using \pkg{ggplot2}. If a stratification variable
is provided, counts are calculated per strata and plotted as separate colored lines.
If an additional stratification variable is provided, separate plot windows are created for each level.
}
\examples{
data("toy_data")
# Counts by period, binned by age
plot_binned_counts(toy_data, x = period,
                   bin_by = age, n_bins = 4)
# Counts by period, binned by age, stratified by education levels
plot_binned_counts(toy_data, period,
                   bin_by = age, n_bins = 4,
                   stratify_by = education)
# Counts by period, binned by age, stratified by education levels, for each sex
plot_binned_counts(toy_data, period,
                   bin_by = age, n_bins = 4,
                   stratify_by = education, for_each = sex)
}
\seealso{
\code{\link{plot_counts_1D}}, \code{\link{plot_counts_2D}},
\code{\link{plot_counts_with_mean}}, \code{\link[ggplot2]{ggplot}}
}
