% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_mave.R
\name{plot.mave}
\alias{plot.mave}
\alias{plot.mave.dim}
\title{Plot of mave or mave.dim object}
\usage{
\method{plot}{mave}(x, dim = 4, plot.method = pairs, ...)

\method{plot}{mave.dim}(x, dim = "dim.min", plot.method = pairs, ...)
}
\arguments{
\item{x}{the object returned by mave}

\item{dim}{the dimension}

\item{plot.method}{the method for plotting scatter plot. The default is 'pairs'}

\item{...}{arguments passed to the plot.method.}
}
\description{
Plot the scatterplot of given dimension directions and reponse variables.
}
\examples{
x = matrix(rnorm(2000),400,5)
beta1 = as.matrix(c(1,1,0,0,0))
beta2 = as.matrix(c(0,0,1,1,0))
err = as.matrix(rnorm(400))
y = (x\%*\%beta1)^2+x\%*\%beta2+err
dr = mave(y~x, method = 'meanopg')
dr.dim = mave.dim(dr)
plot(dr,dim=3)
plot(dr.dim)
}
\seealso{
\code{\link[MAVE]{mave}} for computing the dimension reduction space
}
