% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare.functions.R
\name{genspline}
\alias{genspline}
\title{Generates spline basis matrices for fitting to time-course function}
\usage{
genspline(
  x,
  spline = "bs",
  knots = NULL,
  nknots = 1,
  degree = 1,
  max.time = max(x),
  boundaries = NULL
)
}
\arguments{
\item{x}{A numeric vector indicating all time points available in the dataset}

\item{spline}{Indicates the type of spline function. Can be either a piecewise linear spline (\code{"ls"}),
natural cubic spline (\code{"ns"}) or B-spline (\code{"bs"}).}

\item{knots}{A numeric vector indicating the location of spline internal knots
(\emph{specified on the same scale as \code{time} in the dataset}). Specifying \code{knots} overrides
\code{nknots}.}

\item{nknots}{The number of spline internal knots. If \code{knots} is not specified then these will by
default be evenly spaced between 0 and the maximum follow-up time in the dataset (\code{max.time}).}

\item{degree}{a positive integer giving the degree of the polynomial from which the spline function is composed
(e.g. \code{degree=3} represents a cubic spline).}

\item{max.time}{A number indicating the maximum time between which to calculate the spline function.}

\item{boundaries}{A positive numeric vector of length 2 that represents the time-points at which to anchor the B-spline or natural
cubic spline basis matrix. This allows data to extend beyond the boundary knots, or for the basis parameters to not depend on \code{x}.
The default (\code{boundaries=NULL})is the range of \code{x}.}
}
\value{
A spline basis matrix with number of rows equal to \code{length(x)} and the number of columns equal to the number
of coefficients in the spline.
}
\description{
Generates spline basis matrices for fitting to time-course function
}
\examples{
x <- 0:100

genspline(x)

# Generate a quadratic B-spline with 1 equally spaced internal knot
genspline(x, spline="bs", nknots=1, degree=2)

# Generate a natural spline with 2 knots at times of 10 and 50
genspline(x, spline="ns", knots=c(10, 50))

# Generate a piecewise linear spline with a knot at time=30
genspline(x, spline="ls", knots=30)

}
