% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MFT.peaks.R
\name{MFT.peaks}
\alias{MFT.peaks}
\title{MFT.peaks}
\usage{
MFT.peaks(x, autoset.H = TRUE, S = NULL, E = NULL, H = NULL,
  alpha = 0.05, method = "asymptotic", sim = 10000, Q = NA,
  blocksize = NA, two.sided = FALSE, perform.CPD = TRUE,
  print.output = TRUE)
}
\arguments{
\item{x}{numeric vector, input sequence of random variables}

\item{autoset.H}{logical, automatic choice of window size H}

\item{S}{numeric, start of time interval, default: NULL, if NULL then 1 is chosen}

\item{E}{numeric, end of time interval, default: NULL, if NULL then length(X) is chosen, needs E > S}

\item{H}{vector, window set H, the smallest element must >= 3 be and the largest =< (T/2). H is automatically set if autoset.H = TRUE}

\item{alpha}{numeric, in (0,1), significance level}

\item{method}{either "asymptotic", "bootstrap" or "fixed", defines how threshold Q is derived, default: "asymptotic", If "asymptotic": Q is derived by simulation of limit process L (Gaussian process); possible set number of simulations (sim), If "bootstrap": Q is derived by (Block)-Bootstrapping; possibly set number of simulations (sim) and blocksize (blocksize), If "fixed": Q may be set manually (Q)}

\item{sim}{integer, > 0, No of simulations of limit process (for approximation of Q), default = 10000}

\item{Q}{numeric, rejection threshold, default: Q is simulated according to sim and alpha}

\item{blocksize}{NA or integer >= 1, if method == 'bootstrap', blocksize determines the size of blocks (number of life times) for bootstrapping}

\item{two.sided}{logical, if TRUE a two sided test is performed and also negative peaks are considered in peak detection}

\item{perform.CPD}{logical, if TRUE change point detection algorithm is performed}

\item{print.output}{logical, if TRUE results are printed to the console}
}
\value{
invisible
\item{M}{test statistic}
\item{Q}{rejection threshold}
\item{method}{how threshold Q was derived, see 'Arguments' for detailed description}
\item{sim}{number of simulations of the limit process (approximation of Q)}
\item{blocksize}{size of blocks (number of life times) for bootstrapping (approximation of Q)}
\item{CP}{set of change points estmated by the multiple filter algorithm, increasingly ordered in time}
\item{S}{start of time interval}
\item{E}{end of time interval}
\item{Tt}{length of time interval}
\item{H}{window set}
\item{alpha}{significance level}
\item{two.sided}{logigal, if TRUE also negative peaks are considered}
\item{perform.CPD}{logical, if TRUE change point detection algorithm was performed}
\item{tech.var}{list of technical variables with processes x and D_ht}
\item{type}{type of MFT which was performed: "peaks"}
}
\description{
The multiple filter test for peak detection in time series or sequences of random variables
}
\examples{
# Normal distributed sequence with 2 peaks
set.seed(12)
m <- c(rep(0,30),seq(0,3,length.out = 100),seq(3,0,length.out = 80),rep(0,10),
       seq(0,6,length.out = 50),seq(6,0,length.out = 50),rep(0,30))
x <- rnorm(length(m),m)
mft <- MFT.peaks(x)
plot(mft)
# Set additional parameters (window set)
mft <- MFT.peaks(x,autoset.H = FALSE, H =c(30,60,90))
plot(mft)

}
\references{
Michael Messer, Hendrik Backhaus, Albrecht Stroh and Gaby Schneider (2019+). Peak detection in times series
}
\seealso{
\code{\link{MFT.filterdata}, \link{plot.MFT}, \link{summary.MFT}, \link{MFT.mean}, \link{MFT.rate}, \link{MFT.variance}}
}
\author{
Michael Messer, Stefan Albert, Solveig Plomer and Gaby Schneider
}
