% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-1LocusTA.R
\name{cubeOneLocusTA}
\alias{cubeOneLocusTA}
\title{Inheritance Cube: 1 Locus Maternal-Toxin/Zygotic-Antidote System}
\usage{
cubeOneLocusTA(
  TAEfficacy = 1,
  TBEfficacy = 1,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{TAEfficacy}{Maternal toxin A efficacy}

\item{TBEfficacy}{Maternal toxin B efficacy}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This function creates a 1 locus maternal-toxin/zygotic-antidote system. This
is similar to the construct called UDmel. There is no resistance generation
in this model. \cr
This drive has 3 alleles at 1 locus:
\itemize{
\item A: Maternal-toxin 1, zygotic-antidote 2
\item B: Maternal-toxin 2, zygotic-antidote 1
\item W: Wild-type allele
}
}
