% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bAIC.MGLM.R
\name{AIC}
\alias{AIC}
\alias{AIC,MGLMfit-method}
\alias{AIC,MGLMreg-method}
\alias{AIC,MGLMsparsereg-method}
\alias{AIC,MGLMtune-method}
\title{Akaike's Information Criterion (AIC)}
\usage{
\S4method{AIC}{MGLMfit}(object)

\S4method{AIC}{MGLMreg}(object)

\S4method{AIC}{MGLMsparsereg}(object)

\S4method{AIC}{MGLMtune}(object)
}
\arguments{
\item{object}{MGLM object. \code{"MGLMfit"}, \code{"MGLMreg"},
\code{"MGLMsparsereg"}, or \code{"MGLMtune"}}
}
\value{
Returns a numeric value with the corresponding AIC.

For the class \code{"MGLMtune"}, the function returns AIC 
based on the optimal tuning parameter.
}
\description{
Calculates the Akaike's information criterion (AIC) for a fitted model object.
}
\examples{
set.seed(124)
n <- 200
d <- 4
alpha <- rep(1, d-1)
beta <- rep(1, d-1)
m <- 50
Y <- rgdirmn(n, m, alpha, beta)
gdmFit <- MGLMfit(Y, dist="GDM")
AIC(gdmFit)
}
