% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{dhmre_pairwise}
\alias{dhmre_pairwise}
\title{Implied density for pairwise differences given HMRE prior.}
\usage{
dhmre_pairwise(x, mu = 0, sigma = 1)
}
\arguments{
\item{x}{Numeric. Difference in random effects.}

\item{mu}{Numeric. HMRE Prior location.}

\item{sigma}{Numeric. (Default: 1; must be > 0). HMRE prior scale.}
}
\value{
Numeric vector.
}
\description{
Computes the implied densities of random effect differences given HMRE prior.
}
\details{
The HMRE prior for the RE-SD is \eqn{\int N^+(\sigma_p | exp(h_p))LN(h_p | 4\mu, \sqrt{4}\sigma)dh_p}.
The random effects are distributed as \eqn{u_{k,p} \sim N(0, \sigma_p)}.
The implied prior is therefore \eqn{u_{k,p} - u_{\lnot k, p} \sim N(0, \sqrt{2}\sigma)}.
Note that there is a singularity at 0, because the integrand at sigma = 0 is an infinite spike.
We currently integrate (using a change of variables) starting at machine precision-zero. Consider this the approximation of the limit as we approach 0 positively.
This is therefore divergent when assessed at a difference of zero, due to the RESD taking on a zero value (and an infinite function value).
This is expected, as the limit of a Gaussian as sigma -> 0 is the Dirac delta function.
}
\author{
Stephen R. Martin
}
\keyword{internal}
