% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMD_Entropy.R
\name{MMD_Entropy}
\alias{MMD_Entropy}
\title{Loci entropies to measure allele diversity}
\usage{
MMD_Entropy(datafile, popfile, NL, sourcenames, verbose = FALSE)
}
\arguments{
\item{datafile}{character; Name of the file *.csv (with full path in the file system) containing the genotypes (features) of individuals.}

\item{popfile}{character; Name of the file *.pop (with full path in the file system) containing the genotypes (features) of individuals.}

\item{NL}{integer; number of loci. If larger than the number of available loci in the data set, NL is reduced to the maximum available number of loci.}

\item{sourcenames}{a character vector listing the names of the sources.}

\item{verbose}{boolean (TRUE/FALSE) for the display of a progress bar  (Default FALSE)}
}
\value{
A list with
\enumerate{
\item Number of loci.
\item Number of individuals in sources.
\item Table with proportional weight of each population, qs.
\item Number of alleles in the dataset.
\item Value of the alleles in the dataset.
\item Data frame with three columns for entropies: HlT, HlW, HlB
\item Runtime.
}
}
\description{
Loci entropies to measure allele diversity
}
\examples{
## This example uses a small dataset stored in the MMD package
datafile <- system.file("extdata", "Campylobacter_10SNP_HlW.csv", package = "MMD")
popfile <- system.file("extdata", "Campylobacter_10SNP_HlW.pop", package = "MMD")

NL <- 100
sourcenames <- c("Cattle","Chicken","Pig","Sheep","WB")

EntropyLoci <- MMD_Entropy(datafile,popfile,NL,sourcenames)

## See more detailed examples in the vignette.

}
\author{
Francisco J. Perez-Reche (Univeristy of Aberdeen)
}
