% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMD_attr.R
\name{MMD_attr}
\alias{MMD_attr}
\title{Attribution of individuals to sources using the MMD method}
\usage{
MMD_attr(
  datafile,
  popfile,
  NL,
  sourcenames,
  ToAttribute,
  SelfA = "no",
  fSelfA = 0.5,
  randomSelfA = "yes",
  quantile = 0.01,
  optq = "no",
  pqmin = 0,
  pqmax = 0.5,
  np = 20,
  Nbootstrap = 10000,
  verbose = FALSE
)
}
\arguments{
\item{datafile}{character; Name of the file *.csv (with full path in the file system) containing the genotypes (features) of individuals.}

\item{popfile}{character; Name of the file *.pop (with full path in the file system) containing the genotypes (features) of individuals.}

\item{NL}{integer; number of loci. If larger than the number of available loci in the data set, NL is reduced to the maximum available number of loci.}

\item{sourcenames}{a character vector listing the names of the sources.}

\item{ToAttribute}{character giving the name of the individuals of aknown origin (i.e. those that will be attributed to source).}

\item{SelfA}{character; if "no" attribution of individuals to sources is made; if "yes", self-attribution of selected individuals from sources is made. (Default "no")}

\item{fSelfA}{real number in the interval (0,1). When SelfA="yes", fSelfA specifies the fraction of individuals from the source specified by ToAttribute that will be assumed to be of unknown origin. (Default 0.1)}

\item{randomSelfA}{character only relevant if SelfA="yes". If "yes", individuals to be considered as unknown are randomly selected from the source specified by ToAttribute; if "no" a list of names for individuals is read from filepoplist. (Default "yes")}

\item{quantile}{real number with values in (0,1) giving the q-quantile for the MMD method. Only used if the quantile is not obatined through optimisation of the probability of correct self-attribution. (Default 0.01)}

\item{optq}{character; if "no", the specified quantile value is used; if "yes", the q-quantile is optimised (only meaningful for self-attribution so optq="no" automatically if SelfA="no"). (Default "no")}

\item{pqmin}{real number with values in (0,1); minimum value of q-quantile when optq="yes". (Default 0)}

\item{pqmax}{real number with values in (0,1); maximum value of q-quantile when optq="yes". (Default 0.5)}

\item{np}{integer giving the number of values of q-quantile in the interval (pqmin,pqmax) when optq="yes". (Default 20)}

\item{Nbootstrap}{integer giving the number of samples used for bootstrapping to estimate the uncertainty of the attribution probability $p_s$ bootstrap. (Default 10000)}

\item{verbose}{boolean (TRUE/FALSE) for the display of a progress bar  (Default FALSE)}
}
\value{
If optq="yes", the output is a list with seven elements:
\enumerate{
\item Number of individuals from unknown origin.
\item Number of sources.
\item Statistics of the attribution probability to sources, $p_s$.
\item Probability of attribution of each unknown individual to each source $p_{u,s}$
\item Runtime of the calculation.
\item Number of loci.
\item Parameter q used to calculate the q-quantile of the Hamming distance in the MMD method.
\item Data frame giving the probability of correct attribution vs. q-quantile.
}

If optq="no", the output list contains all the items in the list above except the last one.
}
\description{
Attribution of individuals to sources using the MMD method
}
\examples{
## This example uses a small dataset stored in the MMD package
datafile <- system.file("extdata", "Campylobacter_10SNP_HlW.csv", package = "MMD")
popfile <- system.file("extdata", "Campylobacter_10SNP_HlW.pop", package = "MMD")

NL <- 100
sourcenames <- c("Cattle","Chicken","Pig","Sheep","WB")

##----- Source attribution
ToAttribute <- "Human"
SelfA="no"
attribution <- MMD_attr(datafile,popfile,NL,sourcenames,ToAttribute)

## See more detailed examples in the vignette.

}
\author{
Francisco J. Perez-Reche (Univeristy of Aberdeen)
}
