% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MMLR.R
\name{randomizeX}
\alias{randomizeX}
\title{Transformation of regressors' matrix X. Data preparation stage for simulation}
\usage{
randomizeX(X, p = 1, k0 = 1, k1 = 0.5, k2 = 1, k3 = 1)
}
\arguments{
\item{X}{Matrix (n x k), n - number of observations, k - number of columns (k - 1 - number of regressors). Note, that 1st column contains only ones (1) (intercept)}

\item{p}{Scalar (from 1 to +inf), random number for simulation. The default value is 1}

\item{k0}{Scalar. Number from 1 to 3 (distribution selection).
        k0 = 1 - uniform distribution (RV Z ~ U (K1, k2)).
        k0 = 2 - exponential distribution (RV Z ~ exp(lambda)).
        k0 = 3 - Gamma distribution (RV Z ~ gamma(shape, rate)).
The default value is k0 = 1.}

\item{k1}{Scalar. 1) If k0 = 1, then k1 is a left boundary of uniform distribution (RV Z ~ U(k1, k2)).
        2) If k0 = 2, then k1 is a parameter lambda of exponential distribution (RV Z ~ exp(lambda)).
        3) If k0 = 3, then k1 is a shape parameter of Gamma distribution (RV Z ~ gamma(shape, rate)).
The default is k1 = 0.5.}

\item{k2}{Scalar. 1) If k0 = 1, then k2 is a right boundary of uniform distribution (RV Z ~ U(k1, k2).
        2) If k0 = 3, then k2 is a rate parameter of Gamma distribution (RV Z ~ gamma(shape, rate)).
The default is k2 = 1.}

\item{k3}{Scalar. The number of digits after the comma when rounded.
The default value is 1.}
}
\value{
New transformed matrix of regressors (n x k), according to user preferences.
}
\description{
Additional function to be used for simulation purposes (academical or research).
Transforming the matrix of regressors according to user preferences. Random disturbances (according to a chosen distribution) are entered in the initial values of the matrix X.
The expectation of the resulting matrix coincides with the initial matrix X.
}
\details{
Random perturbations are added to the initial values of matrix X elements ($X_{i,j}$ + rnd), which are distributed according to a chosen distribution (possible alternatives: uniform, exponential and gamma distribution).
}
\examples{
Xtest <- cbind(rep_len(1,10),c(2,5,7,3,1,1,2,2,3,6), c(5,9,1,2,3,2,3,5,2,2))
randomizeX(Xtest,1,1,1,2,2)
}
