% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mofat.R
\name{measure}
\alias{measure}
\title{Screening measures}
\usage{
measure(design, y)
}
\arguments{
\item{design}{design matrix, which should have the Sobol' design structure}

\item{y}{response vector}
}
\value{
\item{t}{Total Sobol' index}
\item{mustar}{\eqn{\mu^*} measure}
}
\description{
This function can be used for computing screening measures.
}
\details{
The \code{measure} function computes the screening measures such as the total Sobol' indices (Sobol' 1993)
and \eqn{\mu^*} measure of Campolongo et al. (2007). The design matrix should have the Sobol' design structure.
Please see Xiao et al. (2022) for details.
}
\examples{
#Friedman function
fun <- function (X)
{
 Y <- 10*sin(pi*X[1]*X[2]) + 20*(X[3] - 0.5)^2 + 10*X[4] + 5*X[5]
 return(Y)
}
design = mofat(p=10, l=3)
y = apply(design, 1, fun)

#Screening measures
measure(design, y)
}
\references{
Sobol’, I. M. (1993), “On sensitivity estimation for nonlinear mathematical models,” Mathematical
Modeling and Computational Experiments, 1, 407–414.

Campolongo, F., Cariboni, J., and Saltelli, A. (2007), “An effective screening design for
sensitivity analysis of large models,” Environmental modelling and software, 22, 1509–1518.

Xiao, Q., Joseph, V. R., and Ray, D. M. (2022).
“Maximum One-Factor-At-A-Time  Designs for Screening in Computer Experiments”. Technometrics, to appear.
}
\author{
Qian Xiao and V. Roshan Joseph
}
