% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mcee.R
\name{summary.mcee_fit}
\alias{summary.mcee_fit}
\title{Summarize an mcee fit}
\usage{
\method{summary}{mcee_fit}(
  object,
  lincomb_alpha = NULL,
  lincomb_beta = NULL,
  lincomb_joint = NULL,
  conf_level = 0.95,
  show_nuisance = FALSE,
  ...
)
}
\arguments{
\item{object}{An object of class \code{"mcee_fit"}.}

\item{lincomb_alpha, lincomb_beta}{Optional numeric vector or matrix specifying
linear combinations of \code{alpha} or \code{beta} coefficients.}

\item{lincomb_joint}{Optional numeric vector or matrix specifying linear
combinations of the stacked parameter \code{c(alpha, beta)}.}

\item{conf_level}{Confidence level for Wald intervals (default 0.95).}

\item{show_nuisance}{Logical; if \code{TRUE}, prints a compact summary of Stage-1 nuisance fits.}

\item{...}{Unused.}
}
\value{
A list of class \code{"summary.mcee_fit"} with printed side effects.
}
\description{
Prints coefficient tables for the Natural Direct Excursion Effect (alpha)
and Natural Indirect Excursion Effect (beta), with small-sample t inference.
Optionally reports linear combinations and Stage-1 nuisance summaries.
}
\examples{
# s <- summary(fit, lincomb_alpha = c(1, 9), lincomb_beta = c(1, 9))
}
