% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mr_funnel-methods.R
\docType{methods}
\name{mr_funnel}
\alias{mr_funnel}
\alias{mr_funnel,MRInput-method}
\title{Draw a funnel plot of variant-specific estimates}
\usage{
mr_funnel(object, CI = TRUE)

\S4method{mr_funnel}{MRInput}(object, CI = TRUE)
}
\arguments{
\item{object}{An \code{MRInput} object.}

\item{CI}{A \code{logical} variable dicating as to whether to plot the confidence interval associated with each point. Default value is TRUE.}
}
\description{
The \code{mr_funnel} function draws a funnel plot of variant-specific causal estimates. Estimates (\code{by/bx}) are plotted against the precision of the estimates (\code{abs(bx)/byse}). Precision is the reciprocal of standard error. A vertical dashed line is plotted at the estimate from the \code{mr_ivw} function.
}
\details{
As the function produces a \code{ggplot} object, graphical parameters can be changed by adding commands from the \code{ggplot2} package.
}
\examples{
mr_funnel(mr_input(bx = ldlc, bxse = ldlcse, by = chdlodds, byse = chdloddsse))

}
