% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TreeQuartetDist.R
\name{WQDS}
\alias{WQDS}
\title{Compute the Weighted Quartet Distance Supertree}
\usage{
WQDS(dqt, method = fastme.bal)
}
\arguments{
\item{dqt}{an (\code{n} choose 4) x \code{n+1}) matrix of form output by \code{quartetTableDominant}}

\item{method}{a distance-based tree building function (e.g., fastme.bal, NJ, etc.)}
}
\value{
an unrooted metric tree, of type phylo
}
\description{
Apply the Weighted Quartet Distance Supertree method of \insertCite{YR19;textual}{MSCquartets} to
a collection of quartets on \code{n} taxa together with internal 
quartet branch lengths, specified by a table.
}
\details{
This function is a wrapper which runs \code{quartetWeightedDist}, builds a tree, and then adjusts edge lengths
with \code{WQDSAdjustLengths}.
}
\examples{
gtrees=read.tree(file=system.file("extdata","dataGeneTreeSample",package="MSCquartets"))
tnames=taxonNames(gtrees)
QT=quartetTable(gtrees,tnames[1:6])
RQT=quartetTableResolved(QT)
DQT=quartetTableDominant(RQT,bigweights= "finite")
tree=WQDS(DQT)
write.tree(tree)
plot(tree)

}
\references{
\insertRef{YR19}{MSCquartets}
}
\seealso{
\code{\link{quartetTableDominant}}, 
         \code{\link{quartetWeightedDist}},
         \code{\link{WQDSAdjustLengths}},
         \code{\link{WQDC}}, 
         \code{\link{WQDCrecursive}},
         \code{\link{QDS}}
}
