% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{CalcMPDynamics}
\alias{CalcMPDynamics}
\title{Calculate population dynamics from MP recommendation}
\usage{
CalcMPDynamics(
  MPRecs,
  y,
  nyears,
  proyears,
  nsim,
  Biomass_P,
  VBiomass_P,
  LastTAE,
  histTAE,
  LastSpatial,
  LastAllocat,
  LastTAC,
  TACused,
  maxF,
  LR5_P,
  LFR_P,
  Rmaxlen_P,
  retL_P,
  retA_P,
  retA_P_real,
  retA_P_real_2,
  L5_P,
  LFS_P,
  Vmaxlen_P,
  SLarray_P,
  V_P,
  V_P_real,
  V_P_real_2,
  Fdisc_P,
  DR_P,
  FM_P,
  FM_Pret,
  Z_P,
  CB_P,
  CB_Pret,
  Effort_pot,
  StockPars,
  FleetPars,
  ImpPars,
  checks = FALSE,
  control = list()
)
}
\arguments{
\item{MPRecs}{A named list of MP recommendations. The names are the same as \code{slotNames('Rec')}, except
for \code{Misc}. Each element in the list is a matrix. With the exception of \code{Spatial}, all elements in list
have \code{nrow=1} and \code{ncol=nsim}. \code{Spatial} has \code{nrow=nareas}. Matrices can be empty matrix, populated with all NAs
(both mean no change in management with respect to this element (e.g. \code{Effort})), or populated with a recommendation.
MPs must either return a recommendation or no recommendation for every simulation for a particular slot (i.e. cannot have some NA and some values).}

\item{y}{The projection year}

\item{nyears}{The number of historical years}

\item{proyears}{The number of projection years}

\item{nsim}{The number of simulations}

\item{Biomass_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total biomass in the projection years}

\item{VBiomass_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with vulnerable biomass in the projection years}

\item{LastTAE}{A vector of length \code{nsim} with the most recent TAE}

\item{LastSpatial}{A matrix of \code{nrow=nareas} and \code{ncol=nsim} with the most recent spatial management arrangements}

\item{LastAllocat}{A vector of length \code{nsim} with the most recent allocation}

\item{LastTAC}{A vector of length \code{nsim} with the most recent TAC}

\item{TACused}{A vector of length \code{nsim} with the most recent TAC}

\item{maxF}{A numeric value with maximum allowed F. From \code{OM@maxF}}

\item{LR5_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at 5 percent retention.}

\item{LFR_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at full retention.}

\item{Rmaxlen_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the retention at maximum length.}

\item{retL_P}{An array with dimensions \code{nsim}, \code{nCALbins} and \code{nyears+proyears} with retention at length}

\item{retA_P}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with retention at age}

\item{retA_P_real}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with realized  retention at age. May not asymptote at one}

\item{retA_P_real_2}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} \code{retA_P_real} standardized to max 1}

\item{L5_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at 5 percent selectivity}

\item{LFS_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the first length at full selectivity}

\item{Vmaxlen_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the selectivity at maximum length.}

\item{SLarray_P}{An array with dimensions \code{nsim}, \code{nCALbins} and \code{nyears+proyears} with selectivity at length}

\item{V_P}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with selectivity at age}

\item{V_P_real}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears} with realized selectivity at age. May not asymptote at one}

\item{V_P_real_2}{An array with dimensions \code{nsim}, \code{maxage} and \code{nyears+proyears}. \code{V_P_real} standardized to max 1}

\item{Fdisc_P}{vector of length \code{nsim} with discard mortality. From \code{OM@Fdisc} but can be updated by MP (\code{Rec@Fdisc})}

\item{DR_P}{A matrix with \code{nyears+proyears} rows and \code{nsim} columns with the fraction discarded.}

\item{FM_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total fishing mortality}

\item{FM_Pret}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with fishing mortality of the retained fish}

\item{Z_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total mortality}

\item{CB_P}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with total catch}

\item{CB_Pret}{An array with dimensions \code{nsim}, \code{maxage}, \code{proyears}, and \code{nareas} with retained catch}

\item{Effort_pot}{A numeric vector of potential effort}

\item{StockPars}{A list of stock parameters}

\item{FleetPars}{A list of fleet parameters}

\item{ImpPars}{A list of implementation error parameters}

\item{checks}{Logical. Run internal checks? Currently not used.}

\item{control}{List of control parameters used internally.}
}
\value{
A named list with updated population dynamics
}
\description{
An internal function to calculate the population dynamics for the next time
step based on the recent MP recommendation. First uses \code{.CalcMPDynamics_SelRetDisc} to update selectivity, retention, and discarding parameters,
then calculates F from effort or catch recommendations.
}
\seealso{
\code{\link[=CalcMPDynamics_MF]{CalcMPDynamics_MF()}}
}
\author{
A. Hordyk
}
\keyword{internal}
