% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_grid.R
\name{construct_grid}
\alias{construct_grid}
\title{Computes the location-bandwidth grid for the multiscale test.}
\usage{
construct_grid(t, u_grid = NULL, h_grid = NULL, deletions = NULL)
}
\arguments{
\item{t}{Sample size.}

\item{u_grid}{Vector of location points in the unit interval
\eqn{[0,1]}. If NULL, a default grid is used.}

\item{h_grid}{Vector of bandwidths, each bandwidth is supposed to lie
in \eqn{(0, 0.5)}. If NULL, a default grid is used.}

\item{deletions}{Logical vector of the length len(u.grid) * len(h.grid).
Each element is either TRUE, which means that
the corresponding location-bandwidth point \eqn{(u, h)}
is NOT deleted from the grid, or FALSE, which means that
the corresponding location-bandwidth point \eqn{(u, h)}
IS deleted from the grid. Default is NULL
in which case nothing is deleted.
See vignette for the use.}
}
\value{
A list with the following elements:
   \item{gset}{Matrix of location-bandwidth points \eqn{(u, h)}
                  that remains after deletions, the i-th row gset[i,]
                  corresponds to the i-th point \eqn{(u,h)}.}
    \item{bws}{Vector of bandwidths (after deletions).}
    \item{lens}{Vector of length = length(bws), lens[i] gives
                  the number of locations in the grid for
                  the i-th bandwidth level.}
    \item{gtype}{Type of grid that is used, either 'default' or
                  'non-default'.}
    \item{gset_full}{Matrix of all location-bandwidth pairs \eqn{(u, h)}
                  including deleted ones.}
    \item{pos_full}{Logical vector indicating which points \eqn{(u, h)}
                  have been deleted.}
}
\description{
Computes the location-bandwidth grid for the multiscale test.
}
\examples{
construct_grid(100)
construct_grid(100, u_grid = seq(from = 0.05, to = 1, by = 0.05),
               h_grid = c(0.1, 0.2, 0.3, 0.4))
}
