% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PIRA.R
\name{PIRA}
\alias{PIRA}
\title{Identification of progression independent of relapse activity (PIRA) events}
\usage{
PIRA(Visits, mconf = 3 * 30.25, tRelapse = 30, sustained = TRUE)
}
\arguments{
\item{Visits}{A data frame consisting of 6 columns: ID, dateEDSS, EDSS, daysPostRelapse (days since most recent relapse), bEDSS (baseline EDSS score), base.date (date of bEDSS).}

\item{mconf}{Confirmation period (days) for EDSS progression.}

\item{tRelapse}{Minimum time in days since the most recent relapse to EDSS assessment.}

\item{sustained}{If TRUE, the default, identifies only those PIRA events sustained for the remaining recorded follow-up.}
}
\value{
A data frame.
}
\description{
Identify progression independent of relapse activity (PIRA) events confirmed over a specified time period. The identification of events is based on clinical visit records, each record including entries for patient code, visit date, EDSS score, and days since most recent relapse.
If a baseline EDSS score is not provided, it is determined as the first EDSS score recorded in the dataset outside 30 days (the default) of a relapse.
Following a confirmed PIRA event, the minimum EDSS score within the confirmation period, regardless of the recency of a relapse, becomes the new baseline EDSS score.
Following a relapse, the first EDSS score recorded in the dataset outside 30 days (the default) of a relapse, becomes the new baseline EDSS score.
By default, identify PIRA events that are sustained for the remainder of the follow-up.
}
\examples{
data(SampleData)
output<-PIRA(SampleData)
}
\references{
Dzau, et al. Journal of Neurology, Neurosurgery & Psychiatry 2023;94(12):984-991.
}
