\name{MVN_GibbsSampler}
\alias{MVN_GibbsSampler}
\title{
  Gibbs sampler for MVN distribution
}
\description{
  Generating random vectors on the basis of a given MVN distribution, through Gibbs sampling algorithm.
}
\usage{
# Bayesian posteriori as data
# data <- MVN_BayesianPosteriori(dataset1)

# Using Gibbs sampler to generate random vectors based on Bayesian posteriori:
MVN_GibbsSampler(n, data, initial, reject_rate, burn)
}
\arguments{
  \item{n}{
     A positive integer. The numbers of random vectors to be generated.
}
  \item{data}{
     A double level list which contains the mean vector (\code{data$mean}) and the covariance matrix (\code{data$var}) of a given MVN distribution.
}
  \item{initial}{
     Initial vector where Markov chain starts. Default value use a random vector generated by \code{\link[mvtnorm:Mvnorm]{rmvnorm()}}.
}
  \item{reject_rate}{
     A numeric to control burn-in period by ratio. Default value is 0.2, namely the first 20\% generated vectors will be rejected. If this arg was customized, the next arg \code{burn} should maintain the default value.
}
  \item{burn}{
     A numeric to control burn-in period by numbers. If this arg was customized, final result will be generated by this manner in which it will drop the first n numbers (n=\code{burn}).
}
}
\details{
  There're also some literatures suggest using the mean or mode of priori as initial vector. Users can customize this setting according to their own needs.
}
\value{
  return a series random vectors in the basis of given MVN distribution.
}
\seealso{
 \code{\link[MVNBayesian:MVN_FConditional]{MVN_FConditional}}, \code{\link[MVNBayesian:MatrixAlternative]{MatrixAlternative}}
}
\examples{
library(mvtnorm)

# Get parameters of Bayesian posteriori multivariate normal distribution
BPos <- MVN_BayesianPosteriori(dataset1)
BPos

# Using previous result (BPos) to generate random vectors through Gibbs
# sampling: 7000 observations, start from c(1,1,2), use 0.3 burning rate
BPos_Gibbs <- MVN_GibbsSampler(7000, BPos, initial=c(1,1,2), 0.3)
tail(BPos_Gibbs)

# Check for convergence of Markov chain
BPos$mean
colMeans(BPos_Gibbs)
BPos$var
var(BPos_Gibbs)
\donttest{
# 3d Visulization:
library(rgl)
fac1 <- BPos_Gibbs[,1]
fac2 <- BPos_Gibbs[,2]
fac3 <- BPos_Gibbs[,3]
plot3d(x=fac1, y=fac2, z=fac3, col="red", size=2)
}
}
\keyword{MVN distribution}
\keyword{Gibbs sampling}
