% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/replaceNAMELIST.R
\name{replaceNameList}
\alias{replaceNameList}
\alias{replacePAR}
\title{Replaces a namelist or a parameter}
\usage{
replaceNameList(namelist, datfile, vals)

replacePAR(datfile, parname, namelist, newval, noquotes = TRUE)
}
\arguments{
\item{namelist}{Name of the namelist.}

\item{datfile}{Name of the input file.}

\item{vals}{A list of values (see example below).}

\item{parname}{Name of the parameter to replace the value of.}

\item{newval}{New value of the parameter. Can be a single value or a vector,
or a matrix (see Details).}

\item{noquotes}{Logical. If FALSE, does print quotes around character
values.}
}
\value{
Nothing is returned. The input file is modified.
}
\description{
The function \code{replaceNameList} replaces the whole namelist in an input file.
All parameters in the namelist must be provided, otherwise MAESTRA/MAESPA will likely crash. Or, you can use
\code{replacePAR} to replace a single parameter. If the new parameter value(s) is a vector (or a single value), the values #' will be placed on a single line in the parameter file. If instead a matrix is provided, each row of the matrix is placed on a separate line.

WARNING : The input file is modified. Make sure to backup your original
input files!
}
\examples{
\dontrun{
# Replace an entire namelist
replaceNameList(namelist="aerodyn",
    datfile="trees.dat", vals=list(zht=30,zpd=3,z0ht=0.6))

#' # Replace a parameter with a single value:
replacePAR("trees.dat", "notrees", "plot", newval=100)

# Replace a number of values:
replacePAR("trees.dat", "xycoords", "xy", newval=c(1,1,2,2,3,3))

# Replace a number of values in a different way : this may be useful in
# more complicated programs,
# rr when reading a string from a file (that should be interpreted as a vector).
replacePAR("trees.dat", "xycoords", "xy", newval="1 1 2 2 3 3", noquotes=TRUE)

# Replace a parameter so that the new values are placed on multiple rows.
# Useful for tree namelists with multiple dates and multiple trees
# (where each row corresponds to a tree, and each column to a date.)
m <- matrix(c(1,2,3,4,5,6,7,8,9), nrow=3, byrow=TRUE)
replacePAR("trees.dat", "values", "indivlarea", newval=m)
}
}
\author{
Remko Duursma
}
\seealso{
\code{\link{replacePAR}}
}
\keyword{utilities}

