% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{addManagedWorkerHandles}
\alias{addManagedWorkerHandles}
\alias{getManagedWorkerHandles}
\title{Add or get the worker container handles to the managed cloud provider}
\usage{
addManagedWorkerHandles(provider, handles)

getManagedWorkerHandles(provider)
}
\arguments{
\item{provider}{A \code{ManagedCloudProvider} object}

\item{handles}{the worker container handles}
}
\value{
addManagedWorkerHandles: No return value
getManagedWorkerHandles: A character vector of the worker handles
}
\description{
Add or get the worker container handles to the managed cloud provider. The
handles can be duplicated if multiple workers share the same container
}
\examples{
## make a dummy provider
DummyProvider <- setRefClass("DummyProvider", contains = "ManagedCloudProvider")
provider <- DummyProvider()

## No worker handle in the provider
getManagedWorkerHandles(provider)

## Add worker handles
addManagedWorkerHandles(provider, c("a", "b"))
getManagedWorkerHandles(provider)

## It is possible to add the same handle
## if multiple workers share the same container
addManagedWorkerHandles(provider, c("a"))
getManagedWorkerHandles(provider)
}
