% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mi_train_BP.R
\name{mi_train_BP}
\alias{mi_train_BP}
\title{Train a three layers neural network model.}
\usage{
mi_train_BP(
  train,
  test,
  cls = "class",
  path2save = NULL,
  batch_size = 128,
  epochs = 64,
  validation_split = 0.3,
  verbose = 0
)
}
\arguments{
\item{train}{A dataframe with the \code{class} column as label.}

\item{test}{A dataframe with the \code{class} column as label.}

\item{cls}{A character.The name of the label column.}

\item{path2save}{The folder path to store the model and train history.}

\item{batch_size}{Integer or NULL. The number of samples per gradient update.}

\item{epochs}{The number of epochs to train the model.}

\item{validation_split}{Float between 0 and 1. Fraction of the training data to be used as validation data.}

\item{verbose}{The verbosity mode.}
}
\value{
A \code{list} object containing the prediction confusion matrix, the \code{model} object, and the mapping of predicted numbers to classes.
}
\description{
Train a three layers neural network model.
}
