% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcMWRreview.R
\name{qcMWRreview}
\alias{qcMWRreview}
\title{Create the quality control review report}
\usage{
qcMWRreview(
  res = NULL,
  acc = NULL,
  frecom = NULL,
  cens = NULL,
  fset = NULL,
  output_dir,
  output_file = NULL,
  savesheet = FALSE,
  rawdata = TRUE,
  dqofontsize = 7.5,
  tabfontsize = 9,
  padding = 0,
  warn = TRUE,
  runchk = TRUE
)
}
\arguments{
\item{res}{character string of path to the results file or \code{data.frame} for results returned by \code{\link{readMWRresults}}}

\item{acc}{character string of path to the data quality objectives file for accuracy or \code{data.frame} returned by \code{\link{readMWRacc}}}

\item{frecom}{character string of path to the data quality objectives file for frequency and completeness or \code{data.frame} returned by \code{\link{readMWRfrecom}}}

\item{cens}{character string of path to the censored data file or \code{data.frame} returned by \code{\link{readMWRcens}}}

\item{fset}{optional list of inputs with elements named \code{res}, \code{acc}, \code{frecom}, and \code{cens}, overrides the other arguments}

\item{output_dir}{character string of the output directory for the rendered file}

\item{output_file}{optional character string for the file name}

\item{savesheet}{logical indicating if a spreadsheet of the tables in the report is also saved (default \code{FALSE})}

\item{rawdata}{logical to include quality control accuracy summaries for raw data, e.g., field blanks, etc.}

\item{dqofontsize}{numeric for font size in the data quality objective tables in the first page of the review}

\item{tabfontsize}{numeric for font size in the review tables}

\item{padding}{numeric for row padding for table output}

\item{warn}{logical indicating if warnings from the table functions are included in the file output}

\item{runchk}{logical to run data checks with \code{\link{checkMWRresults}}, \code{\link{checkMWRacc}}, \code{\link{checkMWRfrecom}}, applies only if \code{res}, \code{acc}, or \code{frecom} are file paths}
}
\value{
A compiled review report named \code{qcreview.docx} (or name passed to \code{output_file}) will be saved in the directory specified by \code{output_dir}
}
\description{
Create the quality control review report
}
\details{
The function compiles a review report as a Word document for all quality control checks included in the MassWateR package.  The report shows several tables, including the data quality objectives files for accuracy, frequency, and completeness, summary results for all accuracy checks, summary results for all frequency checks, summary results for all completeness checks, and individual results for all accuracy checks.  The report uses the individual table functions (which can be used separately) to return the results, which include \code{\link{tabMWRacc}}, \code{\link{tabMWRfre}}, and \code{\link{tabMWRcom}}.  The help files for each of these functions can be consulted for a more detailed explanation of the quality control checks.

The workflow for using this function is to import the required data (results, data quality objective, and censored files) and to fix any errors noted on import prior to creating the review report.  Additional warnings that may be of interest as returned by the individual table functions can be returned in the console by setting \code{warn = TRUE}.

Optional arguments that can be changed as needed include specifying the file name with \code{output_file}, suppressing the raw data summaries at the end of the report with \code{rawdata = FALSE}, and changing the table font sizes (\code{dqofontsize} for the data quality objectives on the first page, \code{tabfontsize} for the remainder).  Set \code{savesheet = TRUE} to also save a spreadsheet of the tables in the report.

The function can be used with inputs as paths to the relevant files or as data frames returned by \code{\link{readMWRresults}}, \code{\link{readMWRacc}}, \code{\link{readMWRfrecom}}, and \code{\link{readMWRcens}} (optional).  For the former, the full suite of data checks can be evaluated with \code{runkchk = T} (default) or suppressed with \code{runchk = F}, as explained in the relevant help files.  In the latter case, downstream analyses may not work if data are formatted incorrectly. For convenience, a named list with the input arguments as paths or data frames can be passed to the \code{fset} argument instead. See the help file for \code{\link{utilMWRinput}}.
}
\examples{
# results data path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# dqo accuracy data path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', package = 'MassWateR')

# dqo completeness data path
frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', package = 'MassWateR')

# censored data path
censpth <- system.file('extdata/ExampleCensored.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# accuracy data
accdat <- readMWRacc(accpth)

# frequency and completeness data
frecomdat <- readMWRfrecom(frecompth)

# censored data
censdat <- readMWRcens(censpth)

\donttest{
# create report
qcMWRreview(res = resdat, acc = accdat, frecom = frecomdat, cens = censdat, output_dir = tempdir())
}
}
