% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Maximin.R
\name{Maximin}
\alias{Maximin}
\title{Returns a list that provides materials for later inference method.}
\usage{
Maximin(
  Xlist,
  Ylist,
  loading.mat,
  X0 = NULL,
  cov.shift = TRUE,
  cov0 = NULL,
  intercept = TRUE,
  intercept.loading = FALSE,
  lambda = NULL,
  verbose = FALSE
)
}
\arguments{
\item{Xlist}{list of design matrix for source data, of length \eqn{L}}

\item{Ylist}{list of outcome vector for source data, of length \eqn{L}}

\item{loading.mat}{Loading matrix, of dimension \eqn{n.loading} x \eqn{p}, each column corresponds to a
loading of interest}

\item{X0}{design matrix for target data, of dimension \eqn{n0} x \eqn{p} (default =
\code{NULL})}

\item{cov.shift}{Covariate shifts or not between source and target data (default = \code{TRUE})}

\item{cov0}{Covariance matrix for target data, of dimension \eqn{p} x \eqn{p} (default = \code{NULL})}

\item{intercept}{Should intercept be fitted for the initial estimator
(default = \code{TRUE})}

\item{intercept.loading}{Should intercept term be included for the loading
(default = \code{FALSE})}

\item{lambda}{The tuning parameter in fitting initial model. If \code{NULL},
it will be picked by cross-validation. (default = \code{NULL})}

\item{verbose}{Should intermediate message(s) be printed. (default = \code{FALSE})}
}
\value{
The returned list contains the following components:
\item{Gamma.plugin}{The plugin regression covariance matrix}
\item{Gamma.debias}{The proposed debiased regression covariance matrix}
\item{Var.Gamma}{The variance matrix for sampling the regression covariance matrix}
\item{fits.info}{The list of length \eqn{L}, that contains the initial coefficient estimators and variance of fitted residuals.}
\item{Points.info}{The list of length \eqn{L}, that contains the initial debiased estimator for linear combinations and its corresponding standard error.}
}
\description{
Given list of observations, compute the bias-corrected initial estimators and do bias-correction to the regressopm covariance matrix.
}
\details{
The algorithm implemented scenarios with or without covariate shift. If \code{cov0} is specified,
the \code{X0} will be ignored; if not, while \code{X0} is specified, \code{cov0} will be estimated
by \code{X0}. If both are not specified, the algorithm will automatically set \code{cov.shift} as
\code{FALSE}.
}
\examples{
L = 2
n1 = n2 = 100; p = 4
X1 = MASS::mvrnorm(n1, rep(0,p), Sigma=diag(p))
X2 = MASS::mvrnorm(n2, rep(0,p), Sigma=0.5*diag(p))
b1 = seq(1,4)/10; b2 = rep(0.2, p)
y1 = as.vector(X1\%*\%b1+rnorm(n1)); y2 = as.vector(X2\%*\%b2+rnorm(n2))
loading1 = rep(0.4, p)
loading2 = c(-0.5, -0.5, rep(0,p-2))
loading.mat = cbind(loading1, loading2)
cov0 = diag(p)
mm = Maximin(list(X1,X2),list(y1,y2),loading.mat,cov0=cov0)

# inference
out = Infer(mm, gen.size=10)
}
