% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getVariable.R
\name{getVariable}
\alias{getVariable}
\title{Return SFDF variable at specified locations}
\usage{
getVariable(
  longitude = NULL,
  latitude = NULL,
  dataset = NULL,
  variable = NULL,
  countryCodes = NULL,
  allData = FALSE,
  useBuffering = FALSE
)
}
\arguments{
\item{longitude}{Vector of longitudes in decimal degrees East.}

\item{latitude}{Vector of latitudes in decimal degrees North.}

\item{dataset}{Name of spatial dataset to use.}

\item{variable}{Name of dataframe column to be returned.}

\item{countryCodes}{Vector of ISO 3166-1 alpha-2 country codes.}

\item{allData}{Logical specifying whether a full dataframe should be returned.}

\item{useBuffering}{Logical flag specifying the use of location buffering to
find the nearest polygon if no target polygon is found.}
}
\value{
Vector or dataframe.
}
\description{
Uses spatial comparison to determine which polygons the
locations fall into and returns the variable associated with those polygons.

If \code{allData = TRUE}, the entire dataframe is returned.
}
\seealso{
getSpatialData
}
