% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Magics.R
\name{Magics}
\alias{Magics}
\title{Magics}
\usage{
Magics(data.name, n_genes, covariate.names)
}
\arguments{
\item{data.name}{A data.frame or matrix with N x (2G + k), where N
is the number of samples, G is the number of genes (each gene contributes
two features: one for the zero component and one for the non-zero
component), and K is the number of covariates.}

\item{n_genes}{An interger value. The number of genes (G) represented
in the data.}

\item{covariate.names}{A character vector to specify the column name of covariates.}
}
\value{
A list containing the following elements: (1) estimated coefficients from
the outcome and two mediation models (M and F models in methodology paper); (2) standard errors corresponding to (1);
(3) logical vector indicating whether each gene's mediator
component (M model) is statistically significant; (4) logical vector indicating whether each gene's zero-inflation
component (F model) is statistically significant; (5) Adjusted p-values for M and F model (joint significance test).
}
\description{
A main function for conducting causal mediation analysis
with co-mediators derived from zero-inflated single-cell data.
}
\examples{
\donttest{
data("simulated_data")
n_genes = ncol(simulated_data[, grep("^(M_)", colnames(simulated_data))])
Magics(data.name = simulated_data, n_genes = n_genes, covariate.names = c("Z1", "Z2", "Z3"))
}
}
\references{
Ahn S, Li Z. A Statistical Framework for Co-Mediators of Zero-Inflated Single-Cell RNA-Seq Data.
ArXiv. 2025 July 8:arXiv:2507.06113v1.
Available at: \url{https://arxiv.org/pdf/2507.06113}
}
