% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/total_bias_plot.R
\name{total_bias_plot}
\alias{total_bias_plot}
\title{Plot total bias}
\usage{
total_bias_plot(object, object2 = NULL, rarea = FALSE)
}
\arguments{
\item{object}{list returned by \link{measure_compare} function.}

\item{object2}{(optional) returned by \link{measure_compare} function.
If provided, will plot a second total bias estimate.}

\item{rarea}{if \code{TRUE}, draw the plot with shading areas between
the confidence bands.}
}
\description{
This function draws the "total bias plot", which is used to visually assess
the amount of bias.
It is obtained by graphing the \code{bias} versus the BLUP of the latent trait,
\code{x}, along with the 95\% simultaneous confidence bands.
}
\examples{
\donttest{
### Load the data
data(data1)
### Analysis
measure_model <- measure_compare(data1, nb_simul=100)
### Plot the total bias
total_bias_plot(measure_model)}
}
