
#' @title Method optimization GUI
#'
#' @description `MethodOpt()` runs the GUI.
#'
#' @details
#' No arguments are needed to initiate the GUI. `MethodOpt()` is split into three main tabs.
#'
#' @section Fractional factorial design:
#' The first step in method optimization is to build an experimental design. Hence,
#' the first tab of the GUI is dedicated to designing a fractional factorial experimental design.
#' Parameters are input with their corresponding low and high values. Pressing "Generate FFD" will
#' yield the experimental design. The user will run experiments according to each method.
#'
#' @section ANOVA:
#' The second step in method optimization is to run an ANOVA test. This is carried out
#' under the "Analysis" tab. Raw experimental screening data is uploaded, and the spectra
#' can be viewed. In subtabs, the spectra peaks must be identified (either by an uploaded retention time
#' file or by a built-in identification algorithm), objectives must be selected, and the initial
#' experimental design must be uploaded; then the ANOVA test may be run.
#' Statistically significant parameters are indicated.
#'
#' @section Box-Behnken design:
#' The third step is to generate a three-level Box-Behnken experimental design with the
#' significant parameters. Low, middle, and high values are input with their corresponding
#' parameters. The design can be generated by pressing "Generate BBD."
#'
#' @section Optimization:
#' The final step is to run the optimization with the results of the Box-Behnken design.
#' Similarly to the second step, raw data is uploaded in the "Analysis" tab. Spectra peaks
#' must be identified, objectives
#' must be selected, and the experimental design must be uploaded; then the optimal
#' values can be calculated.
#'
#' @return {No return value, opens and runs the GUI}
#'
#' @examples
#' # Please see the vignette for the MethodOpt package for a full example of how
#' # to use the GUI launched by MethodOpt::MethodOpt().
#'
#' @export

MethodOpt <- function() {

# Run the app ----------------
shiny::shinyApp(ui = ui, server = server)

}

# Notice: These data were produced by Battelle Savannah River Alliance, LLC under Contract No 89303321CEM000080 with the Department of Energy. During the period of commercialization or such other time period specified by DOE, the Government is granted for itself and others acting on its behalf a nonexclusive, paid-up, irrevocable worldwide license in this data to reproduce, prepare derivative works, and perform publicly and display publicly, by or on behalf of the Government. Subsequent to that period, the Government is granted for itself and others acting on its behalf a nonexclusive, paid-up, irrevocable worldwide license in this data to reproduce, prepare derivative works, distribute copies to the public, perform publicly and display publicly, and to permit others to do so. The specific term of the license can be identified by inquiry made to Contract or DOE. NEITHER THE UNITED STATES NOR THE UNITED STATES DEPARTMENT OF ENERGY, NOR ANY OF THEIR EMPLOYEES, MAKES ANY WARRANTY, EXPRESS OR IMPLIED, OR ASSUMES ANY LEGAL LIABILITY OR RESPONSIBILITY FOR THE ACCURACY, COMPLETENESS, OR USEFULNESS OF ANY DATA, APPARATUS, PRODUCT, OR PROCESS DISCLOSED, OR REPRESENTS THAT ITS USE WOULD NOT INFRINGE PRIVATELY OWNED RIGHTS.
# ©2024 Battelle Savannah River Alliance, LLC
