% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CVMSpecificCoxPh.R
\name{CVMSpecificCoxPh}
\alias{CVMSpecificCoxPh}
\title{Cross validation for the Taxon specific analysis}
\usage{
CVMSpecificCoxPh(
  Fold = 3,
  Survival,
  Micro.mat,
  Censor,
  Reduce = TRUE,
  Select = 5,
  Prognostic = NULL,
  Mean = TRUE,
  Quantile = 0.5,
  Ncv = 100
)
}
\arguments{
\item{Fold}{Number of times in which the dataset is divided. Default is 3 which implies dataset will be divided into three groups and 2/3 of the dataset will be the train datset and 1/3 will be to test the results.}

\item{Survival}{A vector of survival time with length equals to number of subjects}

\item{Micro.mat}{A large or small microbiome profile matrix. A matrix with microbiome profiles where the number of rows should be equal to the number of taxa and number of columns should be equal to number of patients.}

\item{Censor}{A vector of censoring indicator.}

\item{Reduce}{A boolean parameter indicating if the microbiome profile matrix should be reduced, default is TRUE and larger microbiome profile matrix is reduced by supervised pca approach and first pca is extracted from the reduced matrix to be used in the classifier.}

\item{Select}{Number of taxa (default is 5) to be selected from supervised PCA. This is valid only if th argument Reduce=TRUE.}

\item{Prognostic}{A dataframe containing possible prognostic(s) factor and/or treatment effect to be used in the model.}

\item{Mean}{The cut off value for the classifier, default is the mean cutoff.}

\item{Quantile}{If users want to use quantile as cutoff point. They need to specify Mean = FALSE and a quantile that they wish to use. The default is the median cutoff.}

\item{Ncv}{The Number of cross validation loop. Default is 100.}
}
\value{
A object of class \code{\link[MicrobiomeSurv]{cvmm}} is returned with the following values.
  \item{HRTrain}{The Train dataset HR statistics for each taxon by the number of CV.}
  \item{HRTest}{The Test dataset HR statistics for each taxon by the number of CV.}
  \item{train}{The selected subjects for each CV in the train dataset.}
  \item{test}{The selected subjects for each CV in the test dataset.}
\item{n.mi}{The number of taxa used in the analysis.}
 \item{Ncv}{The number of cross validation performed.}
 \item{Rdata}{The Microbiome data matrix that was used for the analysis either same as Micro.mat or a reduced version.}
}
\description{
The function performs cross validation for each taxon depending the number of fold which guides the division into the train and testing dataset.
The classifier is then obtained on the training dataset to be validated on the test dataset.
}
\details{
This function performs the cross validation for taxon by taxon analysis.
The data will firstly be divided into data train dataset and test datset.
Furthermore, a taxon-specific model is fitted on train data and a classifier is built.
In addition, the classifier is then evaluated on test dataset for each particular taxon.
The Process is repeated for all the full or reduced taxa to obtaind the HR statistics of the low risk group.
The following steps depends on the number of cross validation specified.
}
\examples{
\donttest{
# Prepare data
data(Week3_response)
Week3_response = data.frame(Week3_response)
surv_fam_shan_w3 = data.frame(cbind(as.numeric(Week3_response$T1Dweek),
as.numeric(Week3_response$T1D)))
colnames(surv_fam_shan_w3) = c("Survival", "Censor")
prog_fam_shan_w3 = data.frame(factor(Week3_response$Treatment_new))
colnames(prog_fam_shan_w3) = c("Treatment")
data(fam_shan_trim_w3)
names_fam_shan_trim_w3 =
c("Unknown", "Lachnospiraceae", "S24.7", "Lactobacillaceae", "Enterobacteriaceae", "Rikenellaceae")
fam_shan_trim_w3 = data.matrix(fam_shan_trim_w3[ ,2:82])
rownames(fam_shan_trim_w3) = names_fam_shan_trim_w3
# Using the function
CVCox_taxon_fam_shan_w3 = CVMSpecificCoxPh(Fold=3,
                                           Survival = surv_fam_shan_w3$Survival,
                                           Micro.mat = fam_shan_trim_w3,
                                           Censor = surv_fam_shan_w3$Censor,
                                           Reduce=TRUE,
                                           Select=5,
                                           Prognostic=prog_fam_shan_w3,
                                           Mean = TRUE,
                                           Ncv=10)

# Get the class of the object
class(CVCox_taxon_fam_shan_w3)     # An "cvmm" Class

# Method that can be used for the result
show(CVCox_taxon_fam_shan_w3)
summary(CVCox_taxon_fam_shan_w3)
plot(CVCox_taxon_fam_shan_w3)
}
}
\seealso{
\code{\link[survival]{coxph}},
\code{\link[MicrobiomeSurv]{EstimateHR}}, \code{\link[MicrobiomeSurv]{MSpecificCoxPh}},
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
