% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SecondFilter.R
\name{SecondFilter}
\alias{SecondFilter}
\title{This function is used for the second step of filtering which removes OTUs based on a threshold.}
\usage{
SecondFilter(zero.per.group, Micro.mat, threshold = 0.7, week = 0)
}
\arguments{
\item{zero.per.group}{a n x 9 matrix. Columns are number of zero in control groups, proportion of zeros in control group,
number of subject in control group, number of zero in treated groups, proportion of zeros in treated group,
number of subject in treated group, total number of zeros, proportion of zeros in total, number of subject}

\item{Micro.mat}{OTU matrix (rows are otus, columns are subjects)}

\item{threshold}{user can choose. For instance, if threshold is 0.7, the function will remove OTUs having at least 70\% of zeros in one of two groups}

\item{week}{A specific time point. To use when having different time points in the dataset.}
}
\value{
A smaller microbiome matrix.
\item{Micro.mat.new}{an smaller OTU matrix with less OTUs}
}
\description{
This function is used for the second step of filtering which removes OTUs based on a threshold.
}
\examples{
# Read dataset
data(Week3_otu)
Week3_otu = data.frame(Week3_otu)
otu_mat_w3 = t(data.matrix(Week3_otu[ , 1:2720]))

# Import dataset from the result of zero_per_group
data(data_zero_per_group_otu_w3)

# Using the function
otu_trim_w3 = SecondFilter(zero.per.group = data_zero_per_group_otu_w3,
                           Micro.mat = otu_mat_w3, threshold = 0.7, week = 3)
}
\seealso{
\code{\link[MicrobiomeSurv]{SecondFilter}}

\code{\link[MicrobiomeSurv]{SecondFilter}}
}
\author{
Thi Huyen Nguyen, \email{thihuyen.nguyen@uhasselt.be}

Olajumoke Evangelina Owokotomo, \email{olajumoke.x.owokotomo@gsk.com}

Ziv Shkedy
}
