% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{sankey_pq}
\alias{sankey_pq}
\title{Sankey plot of \code{\link[phyloseq]{phyloseq-class}} object}
\usage{
sankey_pq(
  physeq = NULL,
  fact = NULL,
  taxa = 1:4,
  add_nb_seq = FALSE,
  min_prop_tax = 0,
  tax2remove = NULL,
  units = NULL,
  symbol2sub = c("\\\\.", "-"),
  ...
)
}
\arguments{
\item{physeq}{(required) a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{fact}{Name of the factor to cluster samples by modalities.
Need to be in \code{physeq@sam_data}.}

\item{taxa}{a vector of taxonomic rank to plot}

\item{add_nb_seq}{Represent the number of sequences or the
number of OTUs (add_nb_seq = FALSE). Note that plotting the number of
sequences is slower.}

\item{min_prop_tax}{(default: 0) The minimum proportion for taxa to be
plotted. EXPERIMENTAL. For the moment each links below the min.prop.
tax is discard from the sankey network resulting in sometimes weird plot.}

\item{tax2remove}{a vector of taxonomic groups to remove from the analysis
(e.g. \code{c('Incertae sedis', 'unidentified')})}

\item{units}{character string describing physical units (if any) for Value}

\item{symbol2sub}{(default: c('\\.', '-')) vector of symbol to delete in
the taxonomy}

\item{...}{Additional arguments passed on to
\code{\link[networkD3]{sankeyNetwork}}}
}
\value{
A \code{\link[networkD3]{sankeyNetwork}} plot representing the
taxonomic distribution of OTUs or sequences. If \code{fact} is set,
represent the distribution of the last taxonomic level in the modalities
of \code{fact}
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Graphical representation of distribution of taxa across Taxonomy and (optionnaly a factor).
}
\examples{
data("GlobalPatterns", package = "phyloseq")
GP <- subset_taxa(GlobalPatterns, GlobalPatterns@tax_table[, 1] == "Archaea")
if (requireNamespace("networkD3")) {
  sankey_pq(GP, fact = "SampleType")
}
\donttest{
if (requireNamespace("networkD3")) {
  sankey_pq(GP, taxa = 1:4, min_prop_tax = 0.01)
  sankey_pq(GP, taxa = 1:4, min_prop_tax = 0.01, add_nb_seq = TRUE)
}
}
}
\seealso{
\code{\link[networkD3]{sankeyNetwork}}, \code{\link[=ggaluv_pq]{ggaluv_pq()}}
}
\author{
Adrien Taudière
}
