% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cl-def-CooCoe.R
\name{Coe}
\alias{Coe}
\title{Coe "super" class}
\usage{
Coe(...)
}
\arguments{
\item{...}{anything and, anyway, this function will simply returns a message.}
}
\value{
a list of class Coe
}
\description{
\code{Coe} class is the 'parent' or 'super' class of
\code{\link{OutCoe}}, \code{\link{OpnCoe}}, \code{LdkCoe} and \code{TraCoe} classes.
}
\details{
Useful shortcuts are described below. See \code{browseVignettes("Momocs")} for
a detail of the design behind Momocs' classes.

\code{Coe} class is the 'parent' class of the following 'child' classes \itemize{
\item \code{\link{OutCoe}} for coefficients from closed \bold{out}lines morphometrics
\item \code{\link{OpnCoe}} for coefficients from \bold{op}e\bold{n} outlines morphometrics
\item \code{LdkCoe} for coefficients from configuration of \bold{l}an\bold{d}mar\bold{k}s morphometrics.
}

In other words, \code{\link{OutCoe}}, \code{\link{OpnCoe}} and \code{LdkCoe} classes
are all, primarily, \code{Coe} objects on which we define generic \emph{and}
specific methods. See their respective help pages for more help.

You can access all the methods available for \code{Coe} objects
with \code{methods(class=Coe)}.
}
\examples{
# to see all methods for Coe objects.
methods(class='Coe')
# to see all methods for OutCoe objects.
methods(class='OutCoe') # same for OpnCoe, LdkCoe, TraCoe

bot.f <- efourier(bot, 12)
bot.f
class(bot.f)
inherits(bot.f, "Coe")

# if you want to work directly on the matrix of coefficients
bot.f$coe

#getters
bot.f[1]
bot.f[1:5]

#setters
bot.f[1] <- 1:48
bot.f[1]

bot.f[1:5] <- matrix(1:48, nrow=5, ncol=48, byrow=TRUE)
bot.f[1:5]

# An illustration of Momocs design. See also browseVignettes("Momocs")
op <- opoly(olea, 5)
op
class(op)
op$coe # same thing

wp <- fgProcrustes(wings, tol=1e-4)
wp
class(wp) # for Ldk methods, LdkCoe objects can also be considered as Coo objects
# so you can apply all Ldk methods available.
wp$coe # Procrustes aligned coordinates
}
\seealso{
Other classes: 
\code{\link{Coo}()},
\code{\link{Ldk}()},
\code{\link{Opn}()},
\code{\link{OpnCoe}()},
\code{\link{Out}()},
\code{\link{OutCoe}()},
\code{\link{TraCoe}()}
}
\concept{classes}
