% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MplusTrees.R
\name{MplusTrees}
\alias{MplusTrees}
\title{Recursive partitioning trees with Mplus models}
\usage{
MplusTrees(
  script,
  data,
  rPartFormula,
  catvars = NULL,
  group = ~id,
  control = rpart.control(),
  se = F,
  psplit = F,
  palpha = 0.05,
  cv = F,
  k = 5
)
}
\arguments{
\item{script}{An \code{MplusAutomation} script file}

\item{data}{Dataset that is specified in the script}

\item{rPartFormula}{Formula of the form ~ variable names}

\item{catvars}{Vector of names of categorical covariates}

\item{group}{id variable. If not specified an id variable is created for each row}

\item{control}{Control object for \code{rpart}}

\item{se}{Whether to print standard errors and \emph{p} values. In general should be set to FALSE}

\item{psplit}{Whether to use likelihood ratio \emph{p} values as a splitting criterion}

\item{palpha}{Type I error rate (alpha level) for rejecting with likelihood ratio test when
\code{psplit} set to \code{TRUE}}

\item{cv}{Performs k-fold cross-validation to select value of \code{cp}}

\item{k}{number of folds for cross-validation}
}
\value{
An object of class '\code{mplustree}'. \code{rpart_out} provides the tree structure, \code{terminal}
gives a vector of terminal nodes, \code{where} shows the terminal node of each id, and \code{estimates} gives
the parameter estimates for each terminal node.
}
\description{
Generates recursive partitioning trees using M\emph{plus} models. \code{MplusTrees()} takes an
M\emph{plus} model written in the form of an \code{MplusAutomation} script, uses
\code{MplusAutomation} to fit the model in M\emph{plus}, and performs recursive partitioning
using \code{rpart}.
}
\details{
The function temporarily changes the working directory to the temporary directory. Files used
and generated by M\emph{plus} are stored here and can be accessed using \code{tempdir()}.

By default \code{MplusTrees()} only splits on the criteria specified in the \code{control}
argument, the most important of which is the \code{cp} parameter. The user can also split on the
\emph{p} value generated from the likelihood ratio test comparing the parent node to a multiple group
model consisting of 2 groups (the daughter nodes). This \emph{p} value criterion is used in addition
to the \code{cp} criterion in that both must be met for a split to be made. The \code{psplit} argument
turns this option on, and \code{palpha} sets the alpha level criterion for rejection.

Cross-validation (CV) can also be used to choose the \code{cp} parameter. If this option is used, any
user-specified \code{cp} value will be overridden by the optimal \code{cp} value chosen by CV. CV fits
the model to the training set and calculates an expected minus 2 log-likelihood (-2LL) for each terminal
node. In the test set, individuals are assigned to terminal nodes based on the tree structure found in
the training set. Their "expected" values are the -2LL values from the respective training set terminal
nodes. The "observed" values are the -2LL values from fitting a multiple group model, with each terminal
node as a group. The \code{cp} value chosen is the one that produces the smallest MSE.

CV should only be used when (1) the M\emph{plus} model can be fit relatively quickly, (2) there are only
a few covariates with a few response options, and (3) the sample size is large enough that the user is
confident the model can be fit without issue in a sample of size \emph{N/k} and a tree that partitions
this sample further. If these conditions are not met, the process could take prohibitively long to arrive
at a solution. Note that if even a single model fails to produce a valid log-likelihood value, the
function will terminate with an error.
}
\examples{
\dontrun{
library(lavaan)

script = mplusObject(
   TITLE = "Example #1 - Factor Model;",
   MODEL = "f1 BY x1-x3; f2 BY x4-x6; f3 BY x7-x9;",
   usevariables = c('x1','x2','x3','x4','x5','x6','x7','x8','x9'),
   rdata = HolzingerSwineford1939)

fit = MplusTrees(script, HolzingerSwineford1939, group=~id,
   rPartFormula=~sex+school+grade,
   control=rpart.control(minsplit=100, minbucket=100, cp=.01))

fit
}
}
\references{
Serang, S., Jacobucci, R., Stegmann, G., Brandmaier, A. M., Culianos, D., & Grimm, K. J. (2021).
Mplus Trees: Structural equation model trees using Mplus. Structural Equation Modeling, 28, 127-137.
}
\author{
Ross Jacobucci and Sarfaraz Serang
}
