% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/updategraph.r
\name{updategraph}
\alias{updategraph}
\title{Update graph}
\usage{
updategraph(
  S1 = c(2, 3),
  W0 = c(0.5, 0.5, 0, 0),
  G0 = rbind(c(0, 0, 1, 0), c(0, 0, 0, 1), c(0, 1, 0, 0), c(1, 0, 0, 0)),
  S0 = seq(1, length(W0), by = 1)
)
}
\arguments{
\item{S1}{Integer indices of the subset of hypotheses, S1 must be a non-empty
subset of \code{S0} and must be sorted increasingly.}

\item{W0}{Numeric vector for the initial weights of the graph.}

\item{G0}{Numeric matrix of dimesion \code{length(W0)} by \code{length(W0)} for the
initial transition matrix of the graph.}

\item{S0}{Integer indices for the set of hypotheses from 1 to length of \code{W0}.}
}
\value{
List with the following elements
\itemize{
\item \code{S1}: Integer indices the same as the input \code{S1}.
\item \code{W1}: Numeric vector for weights of the updated graph.
\item \code{G1}: Numeric transition of the updated graph.
}
}
\description{
\code{updategraph()} updates the graph when only a subset of original hypotheses
is concerned.
}
\examples{
## We can use the function to produce a closed testing tree
## A function to create power set
powerset <- function(x) {
  sets <- lapply(1:(length(x)), function(i) combn(x, i, simplify = FALSE))
  unlist(sets, recursive = FALSE)
}

n <- 3    # number of hypotheses
pn <- 2^n-1
pset <- powerset(seq(1, n, by = 1))    # create the power set
df <- data.frame(matrix(ncol = 1+n, nrow = 0))    # create the dataset
colnames(df) <- c("Test", paste0("H", seq(1, n, by = 1), sep = ""))

W0 <- c(1/3, 1/3, 1/3)    # the weights of the graph
m <- rbind(H1 = c(0, 1/2, 1/2),
           H2 = c(1/2, 0, 1/2),
           H3 = c(1/2, 1/2, 0))
G0 <- matrix(m, nrow = 3, ncol = 3)    # the transition matrix of the graph

for (j in 1:pn){
    abc <- updategraph(S1 = pset[[j]], W0 = W0, G0 = G0)
    temp <- rep("-", n)
    temp[pset[[j]]] <- abc$W1
    temp <- c(paste(pset[[j]], collapse = ""), temp)
    df[j, ] <- temp
}
df    # the dataframe lists the closed testing tree
}
\author{
Xiaodong Luo
}
\concept{closed testing}
\concept{graphical procedure}
\concept{multiple comparison}
