% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkqr.R
\name{KinkTest}
\alias{KinkTest}
\title{Test the existence of kink effect in the multi-kink quantile regression}
\usage{
KinkTest(
  y,
  thre.x,
  cont.z,
  id,
  tau = 0.5,
  NB = 200,
  sparsity = "nid",
  bandwidth_type = c("Hall-Sheather", "Bofinger", "Chamberlain")
)
}
\arguments{
\item{y}{A numeric vector of response.}

\item{thre.x}{A numeric vector of scalar covariate with threshold effect.}

\item{cont.z}{A numeric matrix of design covariates with constant slopes.}

\item{id}{A numeric vector of index used for longitudinal data; can be missing or NULL for iid data.}

\item{tau}{A numeric scalar representing the quantile level (default is 0.5).}

\item{NB}{An integer specifying the resampling times (default is 200).}

\item{sparsity}{The error term type. Specify one from "iid" and "nid" (default is "nid").}

\item{bandwidth_type}{The bandwidth type. Specify one from "Hall-Sheather", "Bofinger", or "Chamberlain" (default is "Hall-Sheather").}
}
\value{
A list containing the p-value (pv), the statistic based on the original data (Tn), and the statistics by wild bootstrap (Tn.NB).
}
\description{
This function tests the existence of a kink effect in the multi-kink quantile regression.
}
\examples{
# Example 1: i.i.d data type
library(quantreg)
n = 200
Z1 <- rexp(n,1)
Z2 <- rbinom(n,1,0.5)
Z <- cbind(Z1,Z2)
epsilon <- rnorm(n,0,1)
X <- runif(n,-2,1)
psi <- c(-1,0)
k <- length(psi)
PSI <- matrix(rep(psi,rep(n,k)),ncol=k)
XP <- matrix(rep(X,k),nrow=n)
XR <- cbind(1,X,pmax((XP-PSI),0),Z)
bet <- c(1,-1,0,0,sqrt(3),-sqrt(3))
Y <- XR \%*\% bet + epsilon
obj <- KinkTest(y=Y,thre.x=X,cont.z=Z,
                bandwidth_type=c("Hall-Sheather"))
obj$pv

\dontrun{
# Example 2: longitudinal data
library(quantreg)
N = 200
T = 5
subject = rep(1:N,each=T)
NT = N*T
Z1 <- rexp(NT,1)
Z2 <- rbinom(NT,1,0.5)
Z <- cbind(Z1,Z2)
epsilon <- rnorm(NT,0,1)
X <- runif(NT,-2,1)
psi <- c(-1,0)
k <- length(psi)
PSI <- matrix(rep(psi,rep(NT,k)),ncol=k)
a <- rnorm(N,0,1)
A <- rep(a,each=T)
XP <- matrix(rep(X,k),nrow=NT)
XR <- cbind(1,X,pmax((XP-PSI),0),Z)
bet <- c(1,-1,0,0,sqrt(3),-sqrt(3))
Y <- XR \%*\% bet + A + epsilon
obj <- KinkTest(y=Y,thre.x=X,cont.z=Z,id=subject,
                bandwidth_type=c("Hall-Sheather"))
obj$pv
}
}
