% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkqr.R
\name{mkqr.fit}
\alias{mkqr.fit}
\title{Fit the multi-kink quantile regression conditional on a given or pre-specified number of change points.}
\usage{
mkqr.fit(
  y,
  thre.x,
  cont.z,
  id,
  tau = 0.5,
  k,
  psi = NULL,
  bandwidth_type = "Hall-Sheather",
  control = fit.control(),
  est.type = "WI",
  wi.type = "general",
  wc.type = "cs"
)
}
\arguments{
\item{y}{A numeric vector of response.}

\item{thre.x}{A numeric vector of scalar covariate with threshold effect.}

\item{cont.z}{A numeric matrix of design with constant slopes.}

\item{id}{A numeric vector of index used for longitudinal data; can be missing or NULL for iid data.}

\item{tau}{The quantile level that belongs to (0,1).}

\item{k}{The pre-specified number of change points.}

\item{psi}{Numeric vector to indicate the starting values for the change points. When psi=NULL (default), k quantiles are assumed.}

\item{bandwidth_type}{The bandwidth type. Specify one from "Hall-Sheather", "Bofinger", and "Chamberlain". Default is "Hall-Sheather".}

\item{control}{A list returned by fit.control.}

\item{est.type}{The estimation type for the longitudinal data. Specify one from "WI", "WC", corresponding to the working independence (WI) estimator and working correlation (WC) estimator. Default is "WI".}

\item{wi.type}{If est.type = "WI", then set the error structure of the variance-covariance matrix estimation. Specify one from "Compound", "AR" and "general".}

\item{wc.type}{If est.type = "WC", then set the correlation structure within subject. Specify one from "ar" and "cs". Default is "cs".}
}
\value{
A list containing the estimated regression coefficients with intercept (bet.est), the estimated standard error of the regression coefficients (bet.se), the estimated change points (psi.est), the estimated standard errors of threshold parameters (psi.se), and the fitted quantile objective value (rho).
}
\description{
Fit the multi-kink quantile regression conditional on a given or pre-specified number of change points.
}
\examples{
\dontrun{
# Simple examples for iid data type
n <- 500
Z1 <- rexp(n, 1)
Z2 <- rbinom(n, 1, 0.5)
Z <- cbind(Z1, Z2)
epsilon <- rnorm(n, 0, 1)
X <- runif(n, -2, 1)
psi <- c(-1, 0)
k <- length(psi)
Y <- XR \%*\% bet + epsilon
result_iid <- mkqr.fit(Y, X, Z, tau = 0.5, k = k)

# Simple examples for longitudinal data
N <- 200
T <- 5
subject <- rep(1:N, each = T)
NT <- N * T
Z1 <- rexp(NT, 1)
Z2 <- rbinom(NT, 1, 0.5)
Z <- cbind(Z1, Z2)
epsilon <- rnorm(NT, 0, 1)
X <- runif(NT, -2, 1)
psi <- c(-1, 0)
k <- length(psi)
PSI <- matrix(rep(psi, rep(NT, k)), ncol = k)
a <- rnorm(N, 0, 1)
A <- rep(a, each = T)
XP <- matrix(rep(X, k), nrow = NT)
XR <- cbind(1, X, pmax((XP - PSI), 0), Z)
bet <- c(1, -1, 3, -3, sqrt(3), -sqrt(3))
Y <- XR \%*\% bet + A + epsilon
tau = 0.5
k = 2

# Example 1: the working independence estimator; the error structure is "general"
est.type = "WI";
wi.type = "Compound"
result_WI_Compound <- mkqr.fit(y = Y, thre.x = X, cont.z = Z, id = subject, tau = tau,
                               k = k, est.type = est.type, wi.type = wi.type)

# Example 2: the working correlated estimator; the correlation structure is "cs"
est.type = "WC";
wc.type = "cs"
result_WC_cs <- mkqr.fit(y = Y, thre.x = X, cont.z = Z, id = subject, tau = tau,
                         k = k, est.type = est.type, wc.type = wc.type)

}
}
