% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/msmediate.R
\name{vartest.msmediate.concurrent}
\alias{vartest.msmediate.concurrent}
\title{Variance testing for complex multisite causal mediation analysis with two concurrent mediators in the presence of complex sample and survey designs and non-random nonresponse}
\usage{
vartest.msmediate.concurrent(
  data,
  y,
  treatment,
  mediator,
  response,
  XR1,
  XR0,
  XM11,
  XM10,
  XM21,
  XM20,
  site,
  sample.weight,
  npermute = 200
)
}
\arguments{
\item{data}{The data set for analysis.}

\item{y}{The name of the outcome variable (string).}

\item{treatment}{The name of the treatment variable (string).}

\item{mediator}{A vecor of two mediator variable names (string).}

\item{response}{The name of the response variable (string), which is equal to 1 if the individual responded and 0 otherwise.}

\item{XR1}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the response under the treatment condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XR0}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the response under the control condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM11}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the first mediator under the treatment condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM10}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the first mediator under the control condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM21}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the second mediator under the treatment condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{XM20}{A vector of variable names (string) of pretreatment covariates in the propensity score model for the second mediator under the control condition. For now, the multilevel propensity score model only allows for one random intercept.}

\item{site}{The variable name for the site ID (string).}

\item{sample.weight}{The variable name for the sample weight given by design (string).}

\item{npermute}{The number of permutations for the permutation test. The default value is 200. It may take a long time, depending on the sample size and the length of X.}
}
\value{
A list contains the hypothesis testing results of the between-site variance of the causal effects, besides the same output as given by the function msmediate().
}
\description{
This function performs hypothesis testing for the between-site variances besides providing the same output as given by the function msmediate.concurrent().
}
\examples{
data(sim.weights)
set.seed(1)
vartest.msmediate.concurrent(data = sim.weights, y = "y", treatment = "tr",
    mediator = c("me", "me2"), response = "R", XR1 = c("x1", "x2", "x3"), XR0 = c("x1",
        "x2", "x3"), XM11 = c("x1", "x2", "x3"), XM10 = c("x1", "x2", "x3"),
    XM21 = c("x1", "x2", "x3"), XM20 = c("x1", "x2", "x3"), site = "site",
    sample.weight = "WD", npermute = 2)

}
\references{
Qin, X., Deutsch, J, & Hong, G. (2021). Unpacking Complex Mediation Mechanisms and Their Heterogeneity between Sites in A Job Corps Evaluation. The Journal of Policy Analysis and Management, 40(1), 158-190. \doi{10.1002/pam.22268}
}
\author{
Xu Qin, Jonah Deutsch, and Guanglei Hong
}
