% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaders.R
\name{getStatsLeader}
\alias{getStatsLeader}
\title{Stats Leader}
\usage{
getStatsLeader(stats_type = c("PTS", "G", "MP", "FG", "FT", "TRB", "AST",
  "STL", "BLK", "TOV", "PF", "FG3"), period = c("career", "season",
  "game"))
}
\arguments{
\item{stats_type}{Stats type. PTS, G, MP, FG, FT, TRB, AST, STL, BLK, TOV, PF or FG3}

\item{period}{Period. career, season or game}
}
\value{
This function returns \code{data.frame} including columns:
\itemize{
 \item Player
 \item Season
 \item stats
 \item value
 \item period
}
}
\description{
Stats Leader data
}
\examples{
\dontrun{
 pts_leader = getStatsLeader(stats_type = "PTS", period = "season")
 head(pts_leader)
}

}
\seealso{
\url{https://www.basketball-reference.com/leaders/}
}
\author{
Koki Ando <koki.25.ando@gmail.com>
}
