% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{addStructure}
\alias{addStructure}
\title{Add structure}
\usage{
addStructure(NGLVieweR, data, format = NULL)
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{data}{Structure data to be added. Can be a PDB entry code (e.g. "7CID"),
a file path to a structure file, or a text representation of the structure.}

\item{format}{Format of the structure file, if reading from a file. Supported
formats are "pdb", "cif", etc. If the file format cannot be inferred from
the file name, this parameter must be specified.}
}
\value{
An updated NGLVieweR object with the added structure.
}
\description{
Add a structure to the NGLVieweR object, either from a PDB entry
code, a file, or directly from the R environment.
}
\details{
This function allows you to add a structure to the NGLVieweR widget.
You can add the structure using a PDB entry code, by specifying a local
file, or by providing the structure data directly. If the format is not
clear from the input, you may need to specify it using the \code{format}
parameter.
}
\examples{
NGLVieweR("1CRN") \%>\%
  addRepresentation("cartoon", param = list(color = "blue")) \%>\%
  addStructure("1CRN") \%>\%
  addRepresentation("cartoon", param = list(color = "orange")) \%>\%
  setPosition(x = 20, y = 0, z = 0) \%>\%
  setRotation(x = 2, y = 0, z = 0, degrees = FALSE) \%>\% 
  setScale(0.5)

# Note: The first "1CRN" structure is represented in blue, while the second 
# "1CRN" structure is represented in orange. Transformations such as 
# setPosition, setRotation, and setScale apply to the second 
# (most recently added) structure.

}
