% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NGLVieweR.R
\name{selectionParameters}
\alias{selectionParameters}
\title{Set selection parameters}
\usage{
selectionParameters(NGLVieweR, proximity = 3, level = "residue")
}
\arguments{
\item{NGLVieweR}{A NGLVieweR object.}

\item{proximity}{Set distance in angstrom for atoms to return in proximity of
selection. Default = \code{3}.}

\item{level}{Set level on which atoms in proximity of selection are returned.
Options are "residue" (default) or atom".}
}
\value{
Returns list of selection parameters to \code{NGLVieweR}
\code{htmlwidgets} object.
}
\description{
Set selection parameters.
}
\examples{
NGLVieweR("7CID") \%>\%
 addRepresentation("cartoon") \%>\%
 selectionParameters(3, "residue")

# Shiny context
if (interactive()) {
   library(shiny)
   ui <- fluidPage(NGLVieweROutput("structure"))
   server <- function(input, output) {
    output$structure <- renderNGLVieweR({
      NGLVieweR("7CID") \%>\%
        addRepresentation("cartoon") \%>\%
        selectionParameters(3, "residue")
    })
    observeEvent(input$structure_selAround, {
      NGLVieweR_proxy("structure") \%>\% removeSelection("selAround")
      NGLVieweR_proxy("structure") \%>\%
        addSelection(
          "ball+stick",
          param =
            list(
              name = "selAround",
              sele = input$structure_selAround,
              colorValue = "grey"
            )
        )
    })
  }
  shinyApp(ui, server)
}

}
