% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_bootstrap.R
\name{bootstrap_variance.data.frame}
\alias{bootstrap_variance.data.frame}
\title{Bootstrap for IID data frames}
\usage{
\method{bootstrap_variance}{data.frame}(
  data,
  estimator_func,
  point_estimate,
  bootstrap_reps = 500,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame}.}

\item{estimator_func}{Function returning an object with a numeric scalar
component \code{y_hat} and an optional logical component \code{converged}.}

\item{point_estimate}{Unused for IID bootstrap, included for signature
consistency.}

\item{bootstrap_reps}{integer; number of resamples.}

\item{...}{Additional arguments. Some are consumed by \code{bootstrap_variance()}
itself (for example \code{resample_guard} for IID bootstrap or
\code{bootstrap_settings}/\code{bootstrap_options}/\code{bootstrap_type}/\code{bootstrap_mse}
or survey bootstrap). Remaining arguments are forwarded to \code{estimator_func}.}
}
\value{
A list with components \code{se}, \code{variance}, and \code{replicates}.
}
\description{
Bootstrap for IID data frames
}
\keyword{internal}
