#' Chemical reaction of two methods
#'
#' This data set is presented by Box et al. (1978, p. 159), where a chemical
#' reaction was studied by making 10 runs with a standard method X, and 10 runs with
#' a new, supposedly improved method Y.
#'
#' @docType data
#'
#' @usage data(ChemicalReaction)
#'
#' @format An object of class \code{"data.frame"}
#' \describe{
#'  \item{method}{Method X or Y}
#'  \item{value}{Chemical reaction values }
#' }
#' @references Box, G.E.P, Hunter, W.G. and Hunter, J.S. (1978). Statistics for Experimenters: An Introduction to Design, Data Analysis and Model Building. New York, Wiley, p.159.
#' @keywords datasets
#' @examples
#' data(ChemicalReaction)
#' head(ChemicalReaction)
#'
"ChemicalReaction"
