% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NRejections.R
\name{fit_model}
\alias{fit_model}
\title{Fit OLS model for a single outcome}
\usage{
fit_model(
  X,
  C = NA,
  Y,
  Ys,
  d,
  center.stats = FALSE,
  bhat.orig = NA,
  alpha = 0.05
)
}
\arguments{
\item{X}{Single quoted name of covariate of interest}

\item{C}{Vector of quoted covariate names}

\item{Y}{Quoted name of single outcome for which model should be fit}

\item{Ys}{Vector of all quoted outcome names}

\item{d}{Dataframe}

\item{center.stats}{Should test statistics be centered by original-sample estimates to enforce
global null?}

\item{bhat.orig}{Estimated coefficients for covariate of interest in original sample (W-vector).
Can be left NA for non-centered stats.}

\item{alpha}{Alpha level for individual tests}
}
\description{
The user does not need to call this function. Fits OLS model for a single outcome with or without centering the test statistics
to enforce the global null.
}
\examples{
data(attitude)
fit_model( X = "complaints",
           C = c("privileges", "learning"),
           Y = "rating",
           Ys = c("rating", "raises"),
           d = attitude,
           center.stats = FALSE,
           bhat.orig = NA,  
           alpha = 0.05 )
}
