% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GompertzExt.r
\name{GompertzExt}
\alias{GompertzExt}
\alias{dgompertz.ext}
\alias{pgompertz.ext}
\alias{qgompertz.ext}
\alias{rgompertz.ext}
\alias{hgompertz.ext}
\title{Gompertz Extension Distribution}
\usage{
dgompertz.ext(x, alpha, lambda, theta, log = FALSE)
pgompertz.ext(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qgompertz.ext(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rgompertz.ext(n, alpha, lambda, theta)
hgompertz.ext(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dgompertz.ext}: numeric vector of (log-)densities
  \item \code{pgompertz.ext}: numeric vector of probabilities
  \item \code{qgompertz.ext}: numeric vector of quantiles
  \item \code{rgompertz.ext}: numeric vector of random variates
  \item \code{hgompertz.ext}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Gompertz Extension distribution.
}
\details{
The Gompertz Extension distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Gompertz Extension distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\quad 1-\exp \left\{-\lambda\left(e^{\alpha x}-1\right)^\theta\right\}
 \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The functions available are listed below:
\itemize{
  \item \code{dgompertz.ext()} — Density function
  \item \code{pgompertz.ext()} — Distribution function
  \item \code{qgompertz.ext()} — Quantile function
  \item \code{rgompertz.ext()} — Random generation
  \item \code{hgompertz.ext()} — Hazard function
}
}
\examples{
x <- seq(1.0, 10, 0.25)
dgompertz.ext(x, 0.1, 5.0, 2.5)
pgompertz.ext(x, 0.1, 5.0, 2.5)
qgompertz.ext(0.5, 0.1, 5.0, 2.5)
rgompertz.ext(10, 0.1, 5.0, 2.5)
hgompertz.ext(x, 0.1, 5.0, 2.5)

# Data
x <- stress
# ML estimates
params = list(alpha=0.0678, lambda=44.34760, theta=2.5225)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pgompertz.ext, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qgompertz.ext, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dgompertz.ext, pfun=pgompertz.ext, plot=TRUE)
print.gofic(out)

}
\references{
Chaudhary, A.K., & Kumar, V. (2020). 
A Bayesian Estimation and Prediction of Gompertz Extension Distribution 
Using the MCMC Method. \emph{Nepal Journal of Science and Technology(NJST)},
\bold{19(1)}, 142--160. \doi{10.3126/njst.v19i1.29795}
}
