% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LindleyExpPower.r
\name{LindleyExpPower}
\alias{LindleyExpPower}
\alias{dlind.exp.pow}
\alias{plind.exp.pow}
\alias{qlind.exp.pow}
\alias{rlind.exp.pow}
\alias{hlind.exp.pow}
\title{Lindley-Exponential Power Distribution}
\usage{
dlind.exp.pow(x, alpha, lambda, theta, log = FALSE)
plind.exp.pow(q, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qlind.exp.pow(p, alpha, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rlind.exp.pow(n, alpha, lambda, theta)
hlind.exp.pow(x, alpha, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dlind.exp.pow}: numeric vector of (log-)densities
  \item \code{plind.exp.pow}: numeric vector of probabilities
  \item \code{qlind.exp.pow}: numeric vector of quantiles
  \item \code{rlind.exp.pow}: numeric vector of random variates
  \item \code{hlind.exp.pow}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Lindley-Exponential Power distribution.
}
\details{
The Lindley-Exponential Power distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\lambda > 0}, and \eqn{\theta > 0}.


The Lindley-Exponential Power distribution has CDF:

\deqn{
F(x; \alpha, \lambda, \theta) =
\quad 1 - \left[ {1 - \left( {\frac{\theta }{{1 + \theta }}} \right)
\left( {1 - {e^{{{\left( {\lambda x} \right)}^\alpha }}}} \right)} 
\right]\exp \left[ {\theta \left( {1 - {e^{{{\left( {\lambda x} \right)}
^\alpha }}}} \right)} \right] \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\lambda}, and \eqn{\theta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dlind.exp.pow()} — Density function
  \item \code{plind.exp.pow()} — Distribution function
  \item \code{qlind.exp.pow()} — Quantile function
  \item \code{rlind.exp.pow()} — Random generation
  \item \code{hlind.exp.pow()} — Hazard function
}
}
\examples{
x <- seq(1.0, 5, 0.25)
dlind.exp.pow(x, 0.5, 0.2, 1.5)
plind.exp.pow(x, 0.5, 0.2, 1.5)
qlind.exp.pow(0.5, 0.5, 0.2, 1.5)
rlind.exp.pow(10, 0.5, 0.2, 1.5)
hlind.exp.pow(x, 0.5, 0.2, 1.5)

# Data
x <- windshield
# ML estimates
params = list(alpha=0.97722, lambda=0.39461, theta=0.96124)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = plind.exp.pow, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qlind.exp.pow, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dlind.exp.pow, pfun=plind.exp.pow, plot=FALSE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2020). 
Lindley exponential power distribution with Properties and Applications. 
\emph{International Journal for Research in Applied Science & Engineering 
Technology (IJRASET)}, \bold{8(10)}, 22--30. \doi{10.22214/ijraset.2020.31743}

Joshi, R.K., & Kumar, V. (2016). 
Exponentiated Power Lindley Distribution : A Bayes Study using MCMC Approach. 
\emph{J. Nat. Acad. Math.}, \bold{30}, 80--102.
}
