\name{stress}
\alias{stress}
\docType{data}

\title{Breaking Stress of Carbon Fibres}

\description{
The dataset contains 100 observations on the breaking stress (in GPa) of carbon
fibres. These measurements were originally reported in Nichols and Padgett
(2006) in the context of bootstrap control charts for Weibull percentiles.
}

\usage{
stress
}

\format{
A numeric vector of length 100 giving observed breaking stress values (in GPa).
}

\value{
An object of class \code{"numeric"}.

The vector consists of 100 observed breaking stress measurements (in
gigapascals) for individual carbon fibre specimens. Each value represents the
stress level at which a single fibre failed. The dataset is commonly used in
reliability engineering and materials science for modeling strength
distributions, fitting Weibull models, and illustrating bootstrap-based
inference and control chart methods.
}

\details{
The breaking stress of carbon fibres is an important characteristic in
materials science and reliability engineering. The data have been widely used
in studies involving Weibull distributions, reliability modelling, and
bootstrap-based inference.

The dataset is frequently cited in literature dealing with Weibull percentiles
and nonparametric control charts.
}

\references{
Nichols, M. D., & Padgett, W. J. (2006).
\emph{A bootstrap control chart for Weibull percentiles}.
Quality and Reliability Engineering International, 22, 141--151.
}

\examples{
stress

# Summary statistics
summary(stress)

# Histogram
hist(
  stress,
  main = "Breaking Stress of Carbon Fibres",
  xlab = "Stress (GPa)"
)
}

\keyword{datasets}
