% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OBMb.R
\name{OBMb}
\alias{OBMb}
\title{Objective Bayesian Analysis for the Mb Capture-Recapture Model}
\usage{
OBMb(k, n, M, x, CI1 = 0.025, CI2 = 0.975, max = 10000, IFMLE = TRUE)
}
\arguments{
\item{k}{Number of sampling occasions}

\item{n}{Total number of distinct animals captured}

\item{M}{Number of marked animals captured in all sampling occasions}

\item{x}{The number of new animals captured at each sampling occasion}

\item{CI1}{Lower confidence level}

\item{CI2}{Upper confidence level}

\item{max}{The maximum of function evaluations used for computing the integrated likelihood L(N|X)}

\item{IFMLE}{Logical, will also print MLE results if TRUE}
}
\value{
\itemize{
 \item{EMEAN: }{Posterior mean for N}
 \item{EMEDIAN: }{Posterior median for N}
 \item {OBCI: }{Credible interval values based on the quantiles specified by CI1 and CI2}
 \item {MLE: }{If IFMLE==TRUE, this is the frequentist MLE for N}
 \item {Ep: }{If IFMLE==TRUE, the frequentist estimate of the initial capture probability p}
 \item {MLECI: }{If IFMLE==TRUE, confidence interval for the MLE quantile specified by CI2}
}
}
\description{
Applies an objective Bayesian method on to the Mb capturere-capture model to estimate the population size N.
}
\examples{

# Data simulation example
k=10
tN=600   #True N
p=0.06
JN=rep(0,k+1)

N=rep(0,k)
x=rep(0,k)
for (j in 1:k){
  N[j]=tN-JN[j]
  x[j]=rbinom(1,N[j],p)
  JN[j+1]=JN[j]+x[j]
}
M=sum(JN[1:k])
n=JN[k+1]

OBMb(k=k,n=n,M=M,x=x)

#Deer mouse example from Otis et al 1978
Data<-c(15, 8, 6, 3, 3, 3)   #new animals captured at each sampling occasion

OBMb(k=6,n=38,M=134,x=Data)
}

