% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clone_ocs.R
\name{clone_ocs}
\alias{clone_ocs}
\title{Clone Case Study Repository}
\usage{
clone_ocs(casestudy, outpath = NULL, fork_repo = NA)
}
\arguments{
\item{casestudy}{character string, name of the case study to clone repository from.
The input name should follow the same naming scheme as the repository on GitHub:

ocs-bp-rural-and-urban-obesity

ocs-bp-air-pollution

ocs-bp-vaping-case-study

ocs-bp-opioid-rural-urban

ocs-bp-RTC-wrangling

ocs-bp-RTC-analysis

ocs-bp-youth-disconnection

ocs-bp-youth-mental-health

ocs-bp-school-shootings-dashboard

ocs-bp-co2-emissions

ocs-bp-diet}

\item{outpath}{character string, path to the directory where the downloaded
repository folder should be saved to.}

\item{fork_repo}{logical, FALSE will clone the repo, while TRUE will fork the repo and then clone the fork.
Default is NA, which will check if you are allowed to push to the repository or not. If you can, the repo
will be cloned. If you cannot push, the repo will be forked and cloned.}
}
\value{
If download is successful, the path to the downloaded data folder is
printed and the logical value TRUE is returned. Otherwise the appropriate error message is printed.
}
\description{
Clone the specified case study repository and save it as a new R project in a local directory.
Need to have a personal access token (PAT) registered to work.
}
\details{
This function clones the specified OCS case study repository
from GitHub and saves it as a new R project in a new folder in
the specified directory. This makes
it so the case study repository, including all of the code, data, and document
files, are cloned with git and downloaded in a single function.
Need to have a personal access token (PAT) to work.
Wrapper for the create_from_github function from usethis.
}
\examples{
\dontrun{
tmp = tempfile()
dir.create(tmp)
clone_ocs("ocs-bp-co2-emissions", outpath = tmp)
}
}
